/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.testtransformation;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.testtransformation.TestMethodFinder;
import java.util.List;

public class BeforeAfterTransformer {
    public static void transformBeforeAfter(ClassOrInterfaceDeclaration clazz, ExecutionConfig config) {
        if (config.isOnlyMeasureWorkload()) {
            BeforeAfterTransformer.transformNoMeasurement(clazz);
        } else if (config.isExecuteBeforeClassInMeasurement()) {
            BeforeAfterTransformer.transformWithMeasurement(clazz);
        }
    }

    public static void transformWithMeasurement(ClassOrInterfaceDeclaration clazz) {
        List<MethodDeclaration> beforeAllMethods = TestMethodFinder.findBeforeAllMethods(clazz);
        BeforeAfterTransformer.transformMethodAnnotations(beforeAllMethods, "de.dagere.kopeme.junit.rule.annotations.BeforeWithMeasurement", 2);
        List<MethodDeclaration> afterAllMethods = TestMethodFinder.findAfterAllMethods(clazz);
        BeforeAfterTransformer.transformMethodAnnotations(afterAllMethods, "de.dagere.kopeme.junit.rule.annotations.AfterWithMeasurement", 2);
    }

    public static void transformNoMeasurement(ClassOrInterfaceDeclaration clazz) {
        List<MethodDeclaration> beforeEachMethods = TestMethodFinder.findBeforeEachMethods(clazz);
        BeforeAfterTransformer.transformMethodAnnotations(beforeEachMethods, "de.dagere.kopeme.junit.rule.annotations.BeforeNoMeasurement", 1);
        List<MethodDeclaration> beforeAllMethods = TestMethodFinder.findBeforeAllMethods(clazz);
        BeforeAfterTransformer.transformMethodAnnotations(beforeAllMethods, "de.dagere.kopeme.junit.rule.annotations.BeforeNoMeasurement", 2);
        List<MethodDeclaration> afterEachMethods = TestMethodFinder.findAfterEachMethods(clazz);
        BeforeAfterTransformer.transformMethodAnnotations(afterEachMethods, "de.dagere.kopeme.junit.rule.annotations.AfterNoMeasurement", 1);
        List<MethodDeclaration> afterAllMethods = TestMethodFinder.findAfterAllMethods(clazz);
        BeforeAfterTransformer.transformMethodAnnotations(afterAllMethods, "de.dagere.kopeme.junit.rule.annotations.AfterNoMeasurement", 2);
    }

    private static void transformMethodAnnotations(List<MethodDeclaration> transformableMethods, String name, int priority) {
        for (MethodDeclaration method : transformableMethods) {
            NormalAnnotationExpr beforeNoMeasurementAnnotation = new NormalAnnotationExpr();
            beforeNoMeasurementAnnotation.setName(name);
            method.getAnnotations().add((Node)beforeNoMeasurementAnnotation);
            beforeNoMeasurementAnnotation.addPair("priority", Integer.toString(priority));
        }
    }
}

