/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.testtransformation;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import de.dagere.peass.config.ExecutionConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public class ClearMockitoCacheTransformer {
    private final ExecutionConfig executionConfig;
    private final ClassOrInterfaceDeclaration clazz;

    public ClearMockitoCacheTransformer(ExecutionConfig executionConfig, ClassOrInterfaceDeclaration clazz) {
        this.executionConfig = executionConfig;
        this.clazz = clazz;
    }

    public void transform() {
        this.createClearCacheMethod();
        LinkedList<String> toAddBeforeEachInitializers = new LinkedList<String>();
        LinkedList<String> toAddBeforeAllInitializers = new LinkedList<String>();
        for (FieldDeclaration field : this.clazz.getFields()) {
            for (VariableDeclarator variable : field.getVariables()) {
                String initializerText;
                Optional initializer = variable.getInitializer();
                if (!initializer.isPresent() || !(initializerText = ((Expression)variable.getInitializer().get()).toString()).contains(".mock(")) continue;
                if (field.isStatic()) {
                    toAddBeforeAllInitializers.add(variable.getNameAsString() + "=" + initializerText + ";");
                } else {
                    toAddBeforeEachInitializers.add(variable.getNameAsString() + "=" + initializerText + ";");
                }
                variable.setInitializer((Expression)null);
                field.setFinal(false);
            }
        }
        if (toAddBeforeEachInitializers.size() > 0) {
            MethodDeclaration firstBeforeEachMethod = this.getBeforeEachMethod();
            this.addInitializers(toAddBeforeEachInitializers, firstBeforeEachMethod);
        }
        if (toAddBeforeAllInitializers.size() > 0) {
            MethodDeclaration firstBeforeAllMethod = this.getBeforeAllMethod();
            this.addInitializers(toAddBeforeAllInitializers, firstBeforeAllMethod);
        }
    }

    private void addInitializers(List<String> toAddBeforeEachInitializers, MethodDeclaration firstBeforeEachMethod) {
        BlockStmt beforeEachMethodBody = (BlockStmt)firstBeforeEachMethod.getBody().get();
        for (String initialization : toAddBeforeEachInitializers) {
            Statement initStatement = StaticJavaParser.parseStatement((String)initialization);
            beforeEachMethodBody.addStatement(0, initStatement);
        }
    }

    private MethodDeclaration getBeforeEachMethod() {
        MethodDeclaration firstBeforeEachMethod = null;
        for (MethodDeclaration method : this.clazz.getMethods()) {
            if (!method.getAnnotationByClass(BeforeEach.class).isPresent()) continue;
            return method;
        }
        firstBeforeEachMethod = this.clazz.addMethod("_peass_setup_each", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        firstBeforeEachMethod.setBody(new BlockStmt());
        firstBeforeEachMethod.addAnnotation("org.junit.jupiter.api.BeforeEach");
        return firstBeforeEachMethod;
    }

    private MethodDeclaration getBeforeAllMethod() {
        MethodDeclaration firstBeforeEachMethod = null;
        for (MethodDeclaration method : this.clazz.getMethods()) {
            if (!method.getAnnotationByClass(BeforeAll.class).isPresent()) continue;
            return method;
        }
        firstBeforeEachMethod = this.clazz.addMethod("_peass_setup_all", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        firstBeforeEachMethod.setBody(new BlockStmt());
        firstBeforeEachMethod.addAnnotation("org.junit.jupiter.api.BeforeAll");
        return firstBeforeEachMethod;
    }

    private void createClearCacheMethod() {
        MethodDeclaration newMethod = this.executionConfig.isExecuteBeforeClassInMeasurement() ? this.clazz.addMethod("_peass_initializeMockito", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC}) : this.clazz.addMethod("_peass_initializeMockito", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        NormalAnnotationExpr afterWithMeasurementAnnotation = newMethod.addAndGetAnnotation("de.dagere.kopeme.junit.rule.annotations.AfterWithMeasurement");
        afterWithMeasurementAnnotation.addPair("priority", Integer.toString(5));
        newMethod.setBody(new BlockStmt());
        ((BlockStmt)newMethod.getBody().get()).addAndGetStatement((Expression)new MethodCallExpr("org.mockito.Mockito.clearAllCaches", new Expression[0]));
    }
}

