/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.testtransformation;

import com.github.javaparser.JavaParser;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import de.dagere.kopeme.datacollection.DataCollectorList;
import de.dagere.nodeDiffDetector.utils.JavaParserProvider;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.testtransformation.BeforeAfterTransformer;
import de.dagere.peass.testtransformation.ParseUtil;
import de.dagere.peass.testtransformation.TestMethodFinder;
import de.dagere.peass.testtransformation.TestMethodHelper;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.rules.TestRule;

public class JUnit4Helper {
    private static final Logger LOG = LogManager.getLogger(JUnit4Helper.class);

    public static void editJUnit4(CompilationUnit unit, MeasurementConfig config, DataCollectorList datacollectorlist) {
        unit.addImport("de.dagere.kopeme.annotations.MaximalRelativeStandardDeviation");
        unit.addImport("org.junit.rules.TestRule");
        unit.addImport("org.junit.Rule");
        unit.addImport("de.dagere.kopeme.junit4.rule.KoPeMeRule");
        ClassOrInterfaceDeclaration clazz = ParseUtil.getClasses(unit).get(0);
        JUnit4Helper.addKoPeMeRuleIfNecessary(clazz);
        if (config.getExecutionConfig().isUseAnbox()) {
            JUnit4Helper.addAnboxRule(unit, clazz);
        }
        List<MethodDeclaration> testMethods = TestMethodFinder.findJUnit4TestMethods(clazz);
        new TestMethodHelper(config, datacollectorlist).prepareTestMethods(testMethods);
        BeforeAfterTransformer.transformBeforeAfter(clazz, config.getExecutionConfig());
    }

    private static void addAnboxRule(CompilationUnit unit, ClassOrInterfaceDeclaration clazz) {
        NodeList arguments = new NodeList();
        arguments.add((Node)new ThisExpr());
        MethodCallExpr methodCallExpr = new MethodCallExpr("GrantPermissionRule.grant", new Expression[0]);
        methodCallExpr.addArgument((Expression)new NameExpr("Manifest.permission.WRITE_EXTERNAL_STORAGE"));
        Type type = StaticJavaParser.parseType((String)"GrantPermissionRule");
        FieldDeclaration fieldDeclaration = new FieldDeclaration();
        VariableDeclarator variable = new VariableDeclarator(type, "mRuntimePermissionRulePeass");
        fieldDeclaration.getVariables().add((Node)variable);
        fieldDeclaration.setModifiers(Modifier.createModifierList((Modifier.Keyword[])new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC}));
        clazz.getMembers().add(0, (Node)fieldDeclaration);
        ((VariableDeclarator)fieldDeclaration.getVariables().iterator().next()).setInitializer((Expression)methodCallExpr);
        NormalAnnotationExpr annotation = new NormalAnnotationExpr();
        annotation.setName("ClassRule");
        fieldDeclaration.getAnnotations().add((Node)annotation);
        unit.getImports().add((Node)new ImportDeclaration("org.junit.ClassRule", false, false));
        unit.getImports().add((Node)new ImportDeclaration("android.Manifest", false, false));
        unit.getImports().add((Node)new ImportDeclaration("androidx.test.rule.GrantPermissionRule", false, false));
    }

    public static void addKoPeMeRuleIfNecessary(ClassOrInterfaceDeclaration clazz) {
        boolean fieldFound;
        boolean bl = fieldFound = JUnit4Helper.hasKoPeMeRule(clazz) || JUnit4Helper.hasKoPeMeRunner(clazz);
        if (!fieldFound) {
            JUnit4Helper.addRule(clazz);
        }
    }

    public static boolean hasKoPeMeRule(ClassOrInterfaceDeclaration clazz) {
        boolean fieldFound = false;
        for (FieldDeclaration field : clazz.getFields()) {
            boolean annotationFound = false;
            for (AnnotationExpr ano : field.getAnnotations()) {
                if (!ano.getNameAsString().equals("Rule")) continue;
                annotationFound = true;
            }
            if (!annotationFound) continue;
            for (Node node : field.getChildNodes()) {
                ObjectCreationExpr expression;
                Expression initializer;
                VariableDeclarator potentialInitializer;
                if (!(node instanceof VariableDeclarator) || !(potentialInitializer = (VariableDeclarator)node).getInitializer().isPresent() || !((Expression)potentialInitializer.getInitializer().get()).isObjectCreationExpr() || !((initializer = (Expression)potentialInitializer.getInitializer().get()) instanceof ObjectCreationExpr) || !(expression = (ObjectCreationExpr)initializer).getTypeAsString().equals("KoPeMeRule")) continue;
                fieldFound = true;
            }
        }
        return fieldFound;
    }

    public static boolean hasKoPeMeRunner(ClassOrInterfaceDeclaration clazz) {
        boolean kopemeTestrunner = false;
        if (clazz.getAnnotations().size() > 0) {
            for (AnnotationExpr annotation : clazz.getAnnotations()) {
                SingleMemberAnnotationExpr singleMember;
                Expression expr;
                if (!annotation.getNameAsString().contains("RunWith") || !(annotation instanceof SingleMemberAnnotationExpr) || !(expr = (singleMember = (SingleMemberAnnotationExpr)annotation).getMemberValue()).toString().equals("PerformanceTestRunnerJUnit.class")) continue;
                kopemeTestrunner = true;
            }
        }
        return kopemeTestrunner;
    }

    public static void addRule(ClassOrInterfaceDeclaration clazz) {
        NodeList arguments = new NodeList();
        arguments.add((Node)new ThisExpr());
        ClassOrInterfaceType kopemeRuleType = (ClassOrInterfaceType)((JavaParser)JavaParserProvider.getJavaparser().get()).parseClassOrInterfaceType("KoPeMeRule").getResult().get();
        ObjectCreationExpr initializer = new ObjectCreationExpr(null, kopemeRuleType, arguments);
        FieldDeclaration fieldDeclaration = clazz.addFieldWithInitializer(TestRule.class, "kopemeRule", (Expression)initializer, new Modifier.Keyword[]{Modifier.publicModifier().getKeyword()});
        NormalAnnotationExpr annotation = new NormalAnnotationExpr();
        annotation.setName("Rule");
        fieldDeclaration.getAnnotations().add((Node)annotation);
    }
}

