/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.testtransformation;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import de.dagere.nodeDiffDetector.config.FolderConfig;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.nodeDiffDetector.typeFinding.TypeFileFinder;
import de.dagere.nodeDiffDetector.typeFinding.TypeFinder;
import de.dagere.nodeDiffDetector.utils.JavaParserProvider;
import de.dagere.peass.testtransformation.JUnitTestTransformer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JUnitTestShortener
implements AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(JUnitTestShortener.class);
    private JUnitTestTransformer transformer;
    private final File module;
    private final Type callee;
    private final String method;
    private final Map<File, File> lastShortenedMap = new HashMap<File, File>();
    private final Set<File> superclasses = new HashSet<File>();
    final File calleeClazzFile;

    public JUnitTestShortener(JUnitTestTransformer transformer, File module, Type callee, String method) {
        this.transformer = transformer;
        this.module = module;
        this.callee = callee;
        this.method = method;
        TypeFileFinder finder = new TypeFileFinder((FolderConfig)transformer.getConfig().getExecutionConfig());
        this.calleeClazzFile = finder.getClazzFile(module, callee);
        this.shortenTest();
    }

    private void shortenTest() {
        if (!this.lastShortenedMap.isEmpty()) {
            throw new RuntimeException("Only use TestShortener once!");
        }
        if (this.calleeClazzFile != null) {
            try {
                this.shortenTestClazz(this.callee, this.calleeClazzFile);
                for (File superclass : this.superclasses) {
                    if (this.lastShortenedMap.containsValue(superclass)) continue;
                    Type callee = new Type(superclass.getName().replaceAll(".java", ""), this.callee.getModule());
                    LOG.debug("Shortening: " + String.valueOf(callee));
                    this.shortenTestClazz(callee, superclass);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            throw new RuntimeException("Could not find " + this.callee.getModule() + "(module) " + this.callee.getClazz() + " java file in " + String.valueOf(this.module) + " - maybe package missing?");
        }
    }

    public File getCalleeClazzFile() {
        return this.calleeClazzFile;
    }

    private void shortenTestClazz(Type callee, File calleeClazzFile) throws IOException {
        int version = this.transformer.getVersion(calleeClazzFile);
        if (version != 0) {
            this.saveUnshortened(calleeClazzFile);
            CompilationUnit calleeUnit = this.transformer.getLoadedFiles().get(calleeClazzFile);
            TypeDeclaration clazz = TypeFinder.findClazz((Type)callee, (List)calleeUnit.getChildNodes());
            if (clazz != null && clazz instanceof ClassOrInterfaceDeclaration) {
                this.shortenParent(this.module, callee, calleeClazzFile, calleeUnit, (ClassOrInterfaceDeclaration)clazz);
                this.removeNonWanted(this.method, version, (ClassOrInterfaceDeclaration)clazz);
                FileUtils.writeStringToFile((File)calleeClazzFile, (String)calleeUnit.toString(), (Charset)Charset.defaultCharset());
            }
        }
    }

    private void saveUnshortened(File calleeClazzFile) throws IOException {
        File tempFile = Files.createTempFile("Temp", ".java", new FileAttribute[0]).toFile();
        FileUtils.copyFile((File)calleeClazzFile, (File)tempFile);
        this.lastShortenedMap.put(tempFile, calleeClazzFile);
    }

    public void shortenParent(File module, Type callee, File calleeClazzFile, CompilationUnit calleeUnit, ClassOrInterfaceDeclaration clazz) throws IOException {
        LOG.debug("Shortening: {}", (Object)callee);
        if (clazz.getExtendedTypes().size() > 0) {
            int version;
            Type parentEntity = this.getParentEntity(callee, calleeUnit, clazz);
            TypeFileFinder finder = new TypeFileFinder((FolderConfig)this.transformer.getConfig().getExecutionConfig());
            File parentClazzFile = finder.getClazzFile(module, parentEntity);
            if (parentClazzFile != null) {
                this.shortenTestClazz(parentEntity, parentClazzFile);
            }
            if ((version = this.transformer.getVersion(calleeClazzFile)) == 3 || version == 34) {
                String simpleClazzName = callee.getSimpleClazzName();
                this.addSuperclasses(simpleClazzName);
            }
        }
    }

    public void addSuperclasses(String simpleClazzName) {
        List<File> thisSuperclasses = this.transformer.getExtensions().get(simpleClazzName);
        if (thisSuperclasses != null) {
            LOG.debug("Must shorten suclasses: {}", thisSuperclasses);
            this.superclasses.addAll(thisSuperclasses);
            for (File superclass : thisSuperclasses) {
                String supersuperclass = superclass.getName().substring(0, superclass.getName().lastIndexOf(46));
                this.addSuperclasses(supersuperclass);
            }
        }
    }

    public Type getParentEntity(Type callee, CompilationUnit calleeUnit, ClassOrInterfaceDeclaration clazz) {
        Type parentEntity = null;
        for (ClassOrInterfaceType parent : clazz.getExtendedTypes()) {
            LOG.debug("Must also shorten {} Package: {}", (Object)parent, (Object)callee.getPackage());
            String parentName = parent.getName().toString();
            Object fqn = this.findFQN(calleeUnit, parentName);
            if (fqn == parentName) {
                fqn = callee.getPackage().equals("") ? parentName : callee.getPackage() + "." + parentName;
            }
            parentEntity = new Type((String)fqn, callee.getModule());
        }
        return parentEntity;
    }

    private void removeNonWanted(String method, int version, ClassOrInterfaceDeclaration clazz) {
        LinkedList<MethodDeclaration> remove = new LinkedList<MethodDeclaration>();
        for (MethodDeclaration methodDeclaration : clazz.getMethods()) {
            if (methodDeclaration.getNameAsString().equals(method)) continue;
            if (methodDeclaration.getModifiers().contains((Node)Modifier.publicModifier()) && methodDeclaration.getParameters().size() == 0) {
                if (version == 3) {
                    if (methodDeclaration.getNameAsString().contains("test")) {
                        remove.add(methodDeclaration);
                    }
                } else {
                    this.removeTestAnnotations(methodDeclaration);
                }
            }
            this.removeParameterizedTestAnnotations(methodDeclaration);
        }
        for (Node node : remove) {
            clazz.remove(node);
        }
    }

    private void removeParameterizedTestAnnotations(MethodDeclaration methodDeclaration) {
        Optional parameterizedTestAnnotation = methodDeclaration.getAnnotationByName("ParameterizedTest");
        Optional testAnnotationFQNJunit5Parameterized = methodDeclaration.getAnnotationByName("org.junit.jupiter.api.ParameterizedTest");
        if (parameterizedTestAnnotation.isPresent()) {
            methodDeclaration.getAnnotations().remove((Node)parameterizedTestAnnotation.get());
        }
        if (testAnnotationFQNJunit5Parameterized.isPresent()) {
            methodDeclaration.getAnnotations().remove((Node)testAnnotationFQNJunit5Parameterized.get());
        }
    }

    private void removeTestAnnotations(MethodDeclaration methodDeclaration) {
        Optional testAnnotation = methodDeclaration.getAnnotationByName("Test");
        Optional testAnnotationFQNJUnit4 = methodDeclaration.getAnnotationByName("org.junit.Test");
        Optional testAnnotationFQNJunit5 = methodDeclaration.getAnnotationByName("org.junit.jupiter.api.Test");
        if (testAnnotation.isPresent()) {
            methodDeclaration.getAnnotations().remove((Node)testAnnotation.get());
        }
        if (testAnnotationFQNJUnit4.isPresent()) {
            methodDeclaration.getAnnotations().remove((Node)testAnnotationFQNJUnit4.get());
        }
        if (testAnnotationFQNJunit5.isPresent()) {
            methodDeclaration.getAnnotations().remove((Node)testAnnotationFQNJunit5.get());
        }
    }

    public String findFQN(CompilationUnit calleeUnit, String parentName) {
        String fqn = parentName;
        for (ImportDeclaration importDecl : calleeUnit.getImports()) {
            if (!importDecl.getNameAsString().endsWith(parentName)) continue;
            fqn = importDecl.getNameAsString();
        }
        return fqn;
    }

    private void resetShortenedFile() {
        if (this.lastShortenedMap != null) {
            for (Map.Entry<File, File> shortened : this.lastShortenedMap.entrySet()) {
                try {
                    File destFile = shortened.getValue();
                    destFile.delete();
                    LOG.debug("File to reset: {} Exists: {} Parent exists: {}", (Object)destFile, (Object)destFile.exists(), (Object)destFile.getParentFile().exists());
                    Path dest = destFile.toPath();
                    Path source = shortened.getKey().toPath();
                    Files.move(source, dest, new CopyOption[0]);
                    CompilationUnit unit = JavaParserProvider.parse((File)destFile);
                    this.transformer.getLoadedFiles().put(destFile, unit);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.resetShortenedFile();
    }
}

