/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.testtransformation;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import de.dagere.kopeme.datacollection.DataCollectorList;
import de.dagere.kopeme.parsing.JUnitParseUtil;
import de.dagere.nodeDiffDetector.config.FolderConfig;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.typeFinding.TypeFileFinder;
import de.dagere.nodeDiffDetector.utils.JavaParserProvider;
import de.dagere.peass.ci.NonIncludedByRule;
import de.dagere.peass.ci.NonIncludedTestRemover;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.RunnableTestInformation;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.execution.utils.ProjectModules;
import de.dagere.peass.testtransformation.BeforeAfterTransformer;
import de.dagere.peass.testtransformation.ClearMockitoCacheTransformer;
import de.dagere.peass.testtransformation.JUnit4Helper;
import de.dagere.peass.testtransformation.JUnitVersions;
import de.dagere.peass.testtransformation.ParseUtil;
import de.dagere.peass.testtransformation.TestMethodFinder;
import de.dagere.peass.testtransformation.TestMethodHelper;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JUnitTestTransformer
implements TestTransformer {
    private static final Logger LOG = LogManager.getLogger(JUnitTestTransformer.class);
    protected DataCollectorList datacollectorlist;
    protected final MeasurementConfig config;
    protected File projectFolder;
    protected boolean ignoreEOIs = false;
    protected Charset charset = StandardCharsets.UTF_8;
    private Map<String, List<File>> extensions = null;
    private Map<File, CompilationUnit> loadedFiles;
    private Map<File, Integer> junitVersions;
    private final JavaParser javaParser = new JavaParser();
    private final Map<Integer, List<String>> junitTestAnnotations = new HashMap<Integer, List<String>>();

    public JUnitTestTransformer(File projectFolder, MeasurementConfig config) {
        this.junitTestAnnotations.put(5, Arrays.asList("org.junit.jupiter.api.Test", "org.junit.jupiter.params.ParameterizedTest"));
        this.junitTestAnnotations.put(4, Arrays.asList("org.junit.Test"));
        LOG.debug("Test transformer for {} created", (Object)projectFolder);
        this.projectFolder = projectFolder;
        this.config = config;
        this.datacollectorlist = config.isDirectlyMeasureKieker() ? DataCollectorList.NONE : (config.isUseGC() ? DataCollectorList.ONLYTIME : DataCollectorList.ONLYTIME_NOGC);
    }

    public Map<File, CompilationUnit> getLoadedFiles() {
        return this.loadedFiles;
    }

    @Override
    public void determineVersions(List<File> modules) {
        String[] pathes = this.config.getExecutionConfig().getTestClazzFolders().toArray(new String[0]);
        this.determineVersionsForPaths(modules, pathes);
    }

    public void determineVersionsForPaths(List<File> modules, String ... testPaths) {
        this.loadedFiles = new HashMap<File, CompilationUnit>();
        this.junitVersions = new HashMap<File, Integer>();
        for (File module : modules) {
            for (String testPath : testPaths) {
                File testFolder = new File(module, testPath);
                if (testFolder.exists()) {
                    this.determineVersions(testFolder);
                    continue;
                }
                LOG.trace("Test folder {} does not exist", (Object)testFolder.getAbsolutePath());
            }
        }
    }

    public Map<File, Integer> getJunitVersions() {
        return this.junitVersions;
    }

    @Override
    public TestSet findModuleTests(ModuleClassMapping mapping, List<String> includedModules, ProjectModules modules) {
        this.determineVersions(modules.getModules());
        TestSet allTests = new TestSet();
        for (File module : modules.getModules()) {
            RunnableTestInformation moduleTests = this.findModuleTests(mapping, includedModules, module);
            allTests.addTestSet(moduleTests.getTestsToUpdate());
        }
        LOG.info("Included tests: {}", (Object)allTests.getTestMethods().size());
        return allTests;
    }

    private RunnableTestInformation findModuleTests(ModuleClassMapping mapping, List<String> includedModules, File module) {
        RunnableTestInformation moduleTests = new RunnableTestInformation();
        TypeFileFinder finder = new TypeFileFinder((FolderConfig)this.config.getExecutionConfig());
        for (String clazz : finder.getTestClazzes(module)) {
            String currentModule = mapping.getModuleOfClass(clazz);
            Set<TestMethodCall> testMethodNames = this.getTestMethodNames(module, new TestClazzCall(clazz, currentModule));
            for (TestMethodCall test : testMethodNames) {
                if (includedModules != null && !includedModules.contains(test.getModule())) continue;
                this.addTestIfIncluded(moduleTests, test, mapping);
            }
        }
        return moduleTests;
    }

    private void addTestIfIncluded(RunnableTestInformation moduleTests, TestMethodCall test, ModuleClassMapping mapping) {
        if (NonIncludedTestRemover.isTestIncluded((TestCase)test, this.getConfig().getExecutionConfig())) {
            if (NonIncludedByRule.isTestIncluded((TestCase)test, this, mapping)) {
                moduleTests.getTestsToUpdate().addTest(test);
            } else {
                moduleTests.getIgnoredTests().addTest(test);
            }
        }
    }

    @Override
    public RunnableTestInformation buildTestMethodSet(TestSet testsToUpdate, ModuleClassMapping mapping) {
        RunnableTestInformation tests = new RunnableTestInformation();
        this.determineVersions(mapping.getModules());
        for (TestClazzCall clazzname : testsToUpdate.getClasses()) {
            Set<String> currentClazzMethods = testsToUpdate.getMethods(clazzname);
            File moduleFolder = new File(this.projectFolder, clazzname.getModule());
            RunnableTestInformation parsedTestInformation = this.getTestRunInformation(moduleFolder, clazzname);
            if (currentClazzMethods == null || currentClazzMethods.isEmpty()) {
                for (TestMethodCall test : parsedTestInformation.getTestsToUpdate().getTestMethods()) {
                    this.addTestIfIncluded(tests, test, mapping);
                }
            } else {
                for (String method : currentClazzMethods) {
                    TestMethodCall test = new TestMethodCall(clazzname.getClazz(), method, clazzname.getModule());
                    this.addTestIfIncluded(tests, test, mapping);
                    if (parsedTestInformation.getTestsToUpdate().containsTest(test) || parsedTestInformation.getIgnoredTests().containsTest(test)) continue;
                    tests.getRemovedTests().addTest(test);
                }
            }
            for (TestMethodCall test : parsedTestInformation.getIgnoredTests().getTestMethods()) {
                tests.getIgnoredTests().addTest(test);
            }
        }
        return tests;
    }

    public void transformTests() {
        if (!this.projectFolder.exists()) {
            LOG.error("Path " + String.valueOf(this.projectFolder) + " not found");
        }
        LOG.trace("Searching: {}", (Object)this.projectFolder);
        for (File file : this.loadedFiles.keySet()) {
            this.increaseVariableValues(file);
        }
        LOG.debug("JUnit Versions Determined: {}", (Object)this.junitVersions.size());
        for (Map.Entry entry : this.junitVersions.entrySet()) {
            LOG.debug("Editing test file: {} {}", entry.getKey(), entry.getValue());
            if ((Integer)entry.getValue() == 3) {
                this.editJUnit3((File)entry.getKey());
                continue;
            }
            if ((Integer)entry.getValue() == 4 || (Integer)entry.getValue() == 34) {
                this.editJUnit4((File)entry.getKey());
                continue;
            }
            if ((Integer)entry.getValue() != 5) continue;
            this.editJUnit5((File)entry.getKey());
        }
    }

    private void increaseVariableValues(File javaFile) {
        CompilationUnit unit = this.loadedFiles.get(javaFile);
        if (this.config.getExecutionConfig().getIncreaseVariableValues().size() > 0) {
            for (ClassOrInterfaceDeclaration clazz : ParseUtil.getClasses(unit)) {
                for (String toIncreaseVariable : this.config.getExecutionConfig().getIncreaseVariableValues()) {
                    Optional fieldOptional;
                    String clazzName = toIncreaseVariable.substring(0, toIncreaseVariable.lastIndexOf("."));
                    String simpleClazzName = clazzName.substring(clazzName.lastIndexOf(".") + 1);
                    String fieldName = toIncreaseVariable.substring(toIncreaseVariable.lastIndexOf(".") + 1, toIncreaseVariable.indexOf(":"));
                    if (!simpleClazzName.equals(clazz.getNameAsString()) || !(fieldOptional = clazz.getFieldByName(fieldName)).isPresent()) continue;
                    FieldDeclaration field = (FieldDeclaration)fieldOptional.get();
                    System.out.println(field);
                    VariableDeclarator variableDeclarator = (VariableDeclarator)field.getVariables().get(0);
                    String value = toIncreaseVariable.substring(toIncreaseVariable.indexOf(":") + 1);
                    variableDeclarator.setInitializer(value);
                    try {
                        Files.write(javaFile.toPath(), unit.toString().getBytes(this.charset), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public int getVersion(File clazzFile) {
        LOG.trace("Loading: {} {}", (Object)clazzFile, this.junitVersions);
        if (this.junitVersions.containsKey(clazzFile)) {
            return this.junitVersions.get(clazzFile);
        }
        return 0;
    }

    private void determineVersions(File testFolder) {
        this.extensions = new HashMap<String, List<File>>();
        for (File javaFile : FileUtils.listFiles((File)testFolder, (IOFileFilter)new WildcardFileFilter("*.java"), (IOFileFilter)TrueFileFilter.INSTANCE)) {
            try {
                boolean isJUnit5;
                File canonicalJavaFile = javaFile.getCanonicalFile();
                CompilationUnit unit = JavaParserProvider.parse((File)canonicalJavaFile);
                this.loadedFiles.put(canonicalJavaFile, unit);
                boolean isJUnit4 = this.isJUnit(unit, 4);
                if (isJUnit4) {
                    this.junitVersions.put(canonicalJavaFile, 4);
                }
                if (isJUnit5 = this.isJUnit(unit, 5)) {
                    this.junitVersions.put(canonicalJavaFile, 5);
                }
                this.parseExtensions(canonicalJavaFile, unit);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.addJUnit3Test("TestCase", this.junitVersions);
    }

    private void parseExtensions(File canonicalJavaFile, CompilationUnit unit) {
        for (ClassOrInterfaceDeclaration clazz : ParseUtil.getClasses(unit)) {
            LOG.trace("Transforming: {}", (Object)clazz.getNameAsString());
            if (clazz.getExtendedTypes().size() != 1) continue;
            ClassOrInterfaceType extend = clazz.getExtendedTypes(0);
            String extensionName = extend.getNameAsString().intern();
            List<File> extensionsOfBase = this.extensions.get(extensionName);
            if (extensionsOfBase == null) {
                extensionsOfBase = new LinkedList<File>();
                this.extensions.put(extensionName, extensionsOfBase);
            }
            extensionsOfBase.add(canonicalJavaFile);
        }
    }

    private boolean isJUnit(CompilationUnit unit, int version) {
        List<String> importNameVersions = this.junitTestAnnotations.get(version);
        boolean isJUnitVersion = false;
        for (ImportDeclaration currentImport : unit.getImports()) {
            Name importName = currentImport.getName();
            for (String importNameVersion : importNameVersions) {
                if (!importName.toString().equals(importNameVersion)) continue;
                isJUnitVersion = true;
            }
        }
        return isJUnitVersion;
    }

    public void addJUnit3Test(String clazzName, Map<File, Integer> junitVersions) {
        List<File> extending = this.extensions.get(clazzName);
        if (extending != null) {
            for (File foundTest : extending) {
                Integer testVersion = junitVersions.get(foundTest);
                if (testVersion != null && testVersion == 4) {
                    junitVersions.put(foundTest, 34);
                } else if (testVersion != null && testVersion == 5) {
                    junitVersions.put(foundTest, 5);
                } else {
                    junitVersions.put(foundTest, 3);
                }
                this.addJUnit3Test(foundTest.getName().replaceAll(".java", ""), junitVersions);
            }
        }
    }

    public Map<String, List<File>> getExtensions() {
        return this.extensions;
    }

    @Override
    public Set<TestMethodCall> getTestMethodNames(File module, TestClazzCall clazzname) {
        RunnableTestInformation rti = this.getTestRunInformation(module, clazzname);
        return rti.getTestsToUpdate().getTestMethods();
    }

    private RunnableTestInformation getTestRunInformation(File module, TestClazzCall clazzname) {
        RunnableTestInformation rti = new RunnableTestInformation();
        TypeFileFinder finder = new TypeFileFinder((FolderConfig)this.config.getExecutionConfig());
        File clazzFile = finder.getClazzFile(module, (TestCase)clazzname);
        CompilationUnit unit = this.loadedFiles.get(clazzFile);
        if (unit != null) {
            Integer junit = this.junitVersions.get(clazzFile);
            if (junit != null) {
                for (ClassOrInterfaceDeclaration clazz : ParseUtil.getClasses(unit)) {
                    String pureClazzName = clazz.getName().toString();
                    if (!pureClazzName.equals(clazzname.getPureClazz())) continue;
                    this.addTestMethodNames((TestCase)clazzname, rti, junit, clazz);
                }
            } else {
                LOG.warn("Clazz {} has no JUnit version", (Object)clazzFile);
            }
        } else {
            this.printSearchDebugInfos((TestCase)clazzname, clazzFile);
        }
        return rti;
    }

    private void printSearchDebugInfos(TestCase clazzname, File clazzFile) {
        LOG.error("Did not find {} for {} - class not loaded (since it is not a test class?)", (Object)clazzFile, (Object)clazzname);
        if (clazzFile != null && clazzFile.getParentFile() != null) {
            if (clazzFile.getParentFile().exists()) {
                LOG.debug("Parent folder {} exists", (Object)clazzFile.getParentFile());
            } else {
                LOG.debug("Parent folder {} does not exist", (Object)clazzFile.getParentFile());
            }
        } else {
            LOG.debug("File is null");
        }
    }

    private void addTestMethodNames(TestCase clazzname, RunnableTestInformation runnableTests, Integer junit, ClassOrInterfaceDeclaration clazz) {
        block6: {
            TestMethodCall test;
            block7: {
                TestMethodCall test2;
                block5: {
                    if (junit != 3) break block5;
                    for (MethodDeclaration method : clazz.getMethods()) {
                        if (!method.getNameAsString().toLowerCase().contains("test")) continue;
                        runnableTests.getTestsToUpdate().addTest(new TestMethodCall(clazzname.getClazz(), method.getNameAsString(), clazzname.getModule()));
                    }
                    break block6;
                }
                if (junit != 4) break block7;
                for (String junit4method : this.getAnnotatedMethods(clazz, 4)) {
                    test2 = new TestMethodCall(clazzname.getClazz(), junit4method, clazzname.getModule());
                    runnableTests.getTestsToUpdate().addTest(test2);
                }
                for (String junit4method : this.getIgnoredMethods(clazz, 4)) {
                    test2 = new TestMethodCall(clazzname.getClazz(), junit4method, clazzname.getModule());
                    runnableTests.getIgnoredTests().addTest(test2);
                }
                break block6;
            }
            if (junit != 5) break block6;
            for (String junit5method : this.getAnnotatedMethods(clazz, 5)) {
                test = new TestMethodCall(clazzname.getClazz(), junit5method, clazzname.getModule());
                runnableTests.getTestsToUpdate().addTest(test);
            }
            for (String junit5method : this.getIgnoredMethods(clazz, 5)) {
                test = new TestMethodCall(clazzname.getClazz(), junit5method, clazzname.getModule());
                runnableTests.getIgnoredTests().addTest(test);
            }
        }
    }

    private List<String> getAnnotatedMethods(ClassOrInterfaceDeclaration clazz, int version) {
        List<String> importNameVersions = this.junitTestAnnotations.get(version);
        LinkedList<String> methods = new LinkedList<String>();
        for (String importNameVersion : importNameVersions) {
            String annotationName = importNameVersion.substring(importNameVersion.lastIndexOf(46) + 1);
            methods.addAll(JUnitParseUtil.getAnnotatedMethods((ClassOrInterfaceDeclaration)clazz, (String)importNameVersion, (String)annotationName));
        }
        return methods;
    }

    private List<String> getIgnoredMethods(ClassOrInterfaceDeclaration clazz, int version) {
        List<String> importNameVersions = this.junitTestAnnotations.get(version);
        LinkedList<String> methods = new LinkedList<String>();
        for (String importNameVersion : importNameVersions) {
            String annotationName = importNameVersion.substring(importNameVersion.lastIndexOf(46) + 1);
            methods.addAll(this.getIgnoredMethods(clazz, importNameVersion, annotationName));
        }
        return methods;
    }

    private List<String> getIgnoredMethods(ClassOrInterfaceDeclaration clazz, String fqnAnnotationName, String annotationName) {
        LinkedList<String> ignoredMethods = new LinkedList<String>();
        boolean clazzDeactivated = JUnitParseUtil.isDeactivated((ClassOrInterfaceDeclaration)clazz);
        for (MethodDeclaration method : clazz.getMethods()) {
            boolean testIsDeactivated;
            boolean found = false;
            for (AnnotationExpr annotation : method.getAnnotations()) {
                String currentName = annotation.getNameAsString();
                if (!currentName.equals(fqnAnnotationName) && !currentName.equals(annotationName)) continue;
                found = true;
            }
            boolean bl = testIsDeactivated = clazzDeactivated || JUnitParseUtil.isDeactivated((MethodDeclaration)method);
            if (!found || !testIsDeactivated) continue;
            ignoredMethods.add(method.getNameAsString());
        }
        return ignoredMethods;
    }

    protected void editJUnit3(File javaFile) {
        try {
            CompilationUnit unit = this.loadedFiles.get(javaFile);
            this.editJUnit3(unit);
            Files.write(javaFile.toPath(), unit.toString().getBytes(this.charset), new OpenOption[0]);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void editJUnit3(CompilationUnit unit) {
        unit.addImport("de.dagere.kopeme.junit3.KoPeMeTestcase");
        unit.addImport("de.dagere.kopeme.datacollection.DataCollectorList");
        for (ClassOrInterfaceDeclaration clazz : ParseUtil.getClasses(unit)) {
            if (clazz.getExtendedTypes().size() <= 0 || clazz.getExtendedTypes(0).getNameAsString().equals("KoPeMeTestcase")) continue;
            if (clazz.getExtendedTypes(0).getNameAsString().equals("TestCase")) {
                clazz.setExtendedTypes(new NodeList());
                clazz.addExtendedType("KoPeMeTestcase");
            }
            this.addMethod(clazz, "getWarmup", "return 0;", (Type)PrimitiveType.intType());
            this.addMethod(clazz, "getIterations", "return " + this.config.getAllIterations() + ";", (Type)PrimitiveType.intType());
            this.addMethod(clazz, "logFullData", "return " + this.config.isLogFullData() + ";", (Type)PrimitiveType.booleanType());
            this.addMethod(clazz, "useKieker", "return " + this.config.getKiekerConfig().isUseKieker() + ";", (Type)PrimitiveType.booleanType());
            this.addMethod(clazz, "getMaximalTime", "return " + this.config.getExecutionConfig().getTimeout() + "l;", (Type)PrimitiveType.longType());
            this.addMethod(clazz, "getRepetitions", "return " + this.config.getRepetitions() + ";", (Type)PrimitiveType.intType());
            this.addMethod(clazz, "redirectToNull", "return " + this.config.getExecutionConfig().isRedirectToNull() + ";", (Type)PrimitiveType.booleanType());
            JavaParser javaParser = this.javaParser;
            synchronized (javaParser) {
                ClassOrInterfaceType type = (ClassOrInterfaceType)this.javaParser.parseClassOrInterfaceType("DataCollectorList").getResult().get();
                if (this.datacollectorlist.equals(DataCollectorList.ONLYTIME)) {
                    this.addMethod(clazz, "getDataCollectors", "return DataCollectorList.ONLYTIME;", (Type)type);
                } else if (this.datacollectorlist.equals(DataCollectorList.ONLYTIME_NOGC)) {
                    this.addMethod(clazz, "getDataCollectors", "return DataCollectorList.ONLYTIME_NOGC;", (Type)type);
                } else if (this.datacollectorlist.equals(DataCollectorList.NONE)) {
                    this.addMethod(clazz, "getDataCollectors", "return DataCollectorList.NONE;", (Type)type);
                }
            }
        }
    }

    protected void addMethod(ClassOrInterfaceDeclaration clazz, String name, String source, Type type) {
        List oldMethods = clazz.getMethodsByName(name);
        if (oldMethods.size() == 0) {
            MethodDeclaration addedMethod = clazz.addMethod(name, new Modifier.Keyword[]{Modifier.publicModifier().getKeyword()});
            addedMethod.setType(type);
            BlockStmt statement = new BlockStmt();
            statement.addStatement(source);
            addedMethod.setBody(statement);
        }
    }

    protected void editJUnit4(File javaFile) {
        try {
            CompilationUnit unit = this.loadedFiles.get(javaFile);
            JUnit4Helper.editJUnit4(unit, this.config, this.datacollectorlist);
            Files.write(javaFile.toPath(), unit.toString().getBytes(this.charset), new OpenOption[0]);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void editJUnit5(File javaFile) {
        try {
            CompilationUnit unit = this.loadedFiles.get(javaFile);
            this.editJUnit5(unit);
            Files.write(javaFile.toPath(), unit.toString().getBytes(this.charset), new OpenOption[0]);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void editJUnit5(CompilationUnit unit) {
        unit.addImport("org.junit.jupiter.api.extension.ExtendWith");
        unit.addImport("de.dagere.kopeme.junit5.extension.KoPeMeExtension");
        for (ClassOrInterfaceDeclaration clazz : ParseUtil.getClasses(unit)) {
            SingleMemberAnnotationExpr extendAnnotation = new SingleMemberAnnotationExpr(new Name("ExtendWith"), (Expression)new ClassExpr((Type)new TypeParameter("KoPeMeExtension")));
            clazz.addAnnotation((AnnotationExpr)extendAnnotation);
            boolean containsMockito = unit.getImports().stream().anyMatch(imp -> imp.getNameAsString().contains("mockito"));
            if (containsMockito) {
                this.eventuallyClearMockitoCache(clazz);
            }
            List<MethodDeclaration> testMethods = TestMethodFinder.findJUnit5TestMethods(clazz);
            new TestMethodHelper(this.config, this.datacollectorlist).prepareTestMethods(testMethods);
            BeforeAfterTransformer.transformBeforeAfter(clazz, this.config.getExecutionConfig());
        }
    }

    private void eventuallyClearMockitoCache(ClassOrInterfaceDeclaration clazz) {
        if (this.config.getExecutionConfig().isClearMockitoCaches()) {
            ClearMockitoCacheTransformer clearMockitoCacheTransformer = new ClearMockitoCacheTransformer(this.config.getExecutionConfig(), clazz);
            clearMockitoCacheTransformer.transform();
        }
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public void setEncoding(Charset encoding) {
        this.charset = encoding;
    }

    @Override
    public JUnitVersions getJUnitVersions() {
        JUnitVersions versions = new JUnitVersions();
        for (Map.Entry<File, Integer> clazz : this.junitVersions.entrySet()) {
            if (clazz.getValue() == 3) {
                versions.setJunit3(true);
                continue;
            }
            if (clazz.getValue() == 4) {
                versions.setJunit4(true);
                continue;
            }
            if (clazz.getValue() != 5) continue;
            versions.setJunit5(true);
        }
        return versions;
    }

    @Override
    public void setIgnoreEOIs(boolean ignoreEOIs) {
        this.ignoreEOIs = ignoreEOIs;
    }

    @Override
    public boolean isIgnoreEOIs() {
        return this.ignoreEOIs;
    }

    @Override
    public MeasurementConfig getConfig() {
        return this.config;
    }
}

