/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.testtransformation;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import de.dagere.kopeme.parsing.JUnitParseUtil;
import java.util.LinkedList;
import java.util.List;

public class TestMethodFinder {
    public static List<MethodDeclaration> findJUnit5TestMethods(ClassOrInterfaceDeclaration clazz) {
        LinkedList<MethodDeclaration> testMethods = new LinkedList<MethodDeclaration>();
        if (JUnitParseUtil.isDeactivated((ClassOrInterfaceDeclaration)clazz)) {
            return testMethods;
        }
        for (MethodDeclaration method : clazz.getMethods()) {
            boolean performanceTestFound = false;
            boolean testFound = false;
            for (AnnotationExpr annotation : method.getAnnotations()) {
                String currentName = annotation.getNameAsString();
                if (currentName.equals("de.dagere.kopeme.annotations.PerformanceTest") || currentName.equals("PerformanceTest")) {
                    performanceTestFound = true;
                }
                if (!currentName.equals("org.junit.Test") && !currentName.equals("org.junit.jupiter.api.Test") && !currentName.equals("Test") && !currentName.equals("ParameterizedTest") && !currentName.equals("org.junit.jupiter.params.ParameterizedTest")) continue;
                testFound = true;
            }
            boolean testIsDeactivated = JUnitParseUtil.isDeactivated((MethodDeclaration)method);
            if (!testFound || performanceTestFound || testIsDeactivated) continue;
            testMethods.add(method);
        }
        return testMethods;
    }

    public static List<MethodDeclaration> findBeforeEachMethods(ClassOrInterfaceDeclaration clazz) {
        String[] annotations = new String[]{"org.junit.Before", "Before", "org.junit.jupiter.api.BeforeEach", "BeforeEach"};
        List<MethodDeclaration> beforeMethods = TestMethodFinder.findAnnotation(clazz, annotations);
        return beforeMethods;
    }

    public static List<MethodDeclaration> findBeforeAllMethods(ClassOrInterfaceDeclaration clazz) {
        String[] annotations = new String[]{"org.junit.jupiter.api.BeforeClass", "BeforeClass", "org.junit.jupiter.api.BeforeAll", "BeforeAll"};
        List<MethodDeclaration> beforeMethods = TestMethodFinder.findAnnotation(clazz, annotations);
        return beforeMethods;
    }

    public static List<MethodDeclaration> findAfterEachMethods(ClassOrInterfaceDeclaration clazz) {
        String[] annotations = new String[]{"org.junit.After", "After", "org.junit.jupiter.api.AfterEach", "AfterEach"};
        List<MethodDeclaration> beforeMethods = TestMethodFinder.findAnnotation(clazz, annotations);
        return beforeMethods;
    }

    public static List<MethodDeclaration> findAfterAllMethods(ClassOrInterfaceDeclaration clazz) {
        String[] annotations = new String[]{"org.junit.jupiter.api.AfterAll", "AfterAll", "org.junit.jupiter.api.AfterAll", "AfterAll"};
        List<MethodDeclaration> beforeMethods = TestMethodFinder.findAnnotation(clazz, annotations);
        return beforeMethods;
    }

    private static List<MethodDeclaration> findAnnotation(ClassOrInterfaceDeclaration clazz, String[] annotations) {
        LinkedList<MethodDeclaration> annotatedMethods = new LinkedList<MethodDeclaration>();
        for (MethodDeclaration method : clazz.getMethods()) {
            AnnotationExpr foundAnnotation = null;
            for (AnnotationExpr annotation : method.getAnnotations()) {
                String currentName = annotation.getNameAsString();
                for (String searchedAnnotation : annotations) {
                    if (!currentName.equals(searchedAnnotation)) continue;
                    foundAnnotation = annotation;
                }
            }
            if (foundAnnotation == null) continue;
            method.getAnnotations().remove(foundAnnotation);
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    public static List<MethodDeclaration> findJUnit4TestMethods(ClassOrInterfaceDeclaration clazz) {
        LinkedList<MethodDeclaration> testMethods = new LinkedList<MethodDeclaration>();
        if (JUnitParseUtil.isDeactivated((ClassOrInterfaceDeclaration)clazz)) {
            return testMethods;
        }
        for (MethodDeclaration method : clazz.getMethods()) {
            boolean performanceTestFound = false;
            boolean testFound = false;
            for (AnnotationExpr annotation : method.getAnnotations()) {
                String currentName = annotation.getNameAsString();
                if (currentName.equals("de.dagere.kopeme.annotations.PerformanceTest") || currentName.equals("PerformanceTest")) {
                    performanceTestFound = true;
                }
                if (!currentName.equals("org.junit.Test") && !currentName.equals("org.junit.jupiter.api.Test") && !currentName.equals("Test")) continue;
                testFound = true;
            }
            boolean testIsDeactivated = JUnitParseUtil.isDeactivated((MethodDeclaration)method);
            if (!testFound || performanceTestFound || testIsDeactivated) continue;
            testMethods.add(method);
        }
        return testMethods;
    }
}

