/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.testtransformation;

import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import de.dagere.kopeme.datacollection.DataCollectorList;
import de.dagere.peass.config.MeasurementConfig;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestMethodHelper {
    private static final Logger LOG = LogManager.getLogger(TestMethodHelper.class);
    private final MeasurementConfig config;
    private final DataCollectorList datacollectorlist;

    public TestMethodHelper(MeasurementConfig config, DataCollectorList datacollectorlist) {
        this.config = config;
        this.datacollectorlist = datacollectorlist;
    }

    public void prepareTestMethods(List<MethodDeclaration> testMethods) {
        for (MethodDeclaration testMethod : testMethods) {
            this.setPublic(testMethod);
            this.addAnnotation(testMethod);
        }
    }

    private void setPublic(MethodDeclaration method) {
        if (!method.isPublic()) {
            method.setPublic(true);
            method.setPrivate(false);
            method.setProtected(false);
            method.setDefault(false);
        }
    }

    public void addAnnotation(MethodDeclaration method) {
        for (AnnotationExpr annotation : method.getAnnotations()) {
            if (!annotation.getNameAsString().contains("PerformanceTest")) continue;
            LOG.info("Found annotation " + annotation.getNameAsString() + " - do not add annotation");
            return;
        }
        NormalAnnotationExpr performanceTestAnnotation = new NormalAnnotationExpr();
        performanceTestAnnotation.setName("de.dagere.kopeme.annotations.PerformanceTest");
        performanceTestAnnotation.addPair("iterations", "" + this.config.getAllIterations());
        performanceTestAnnotation.addPair("warmup", "0");
        performanceTestAnnotation.addPair("executeBeforeClassInMeasurement", "" + this.config.getExecutionConfig().isExecuteBeforeClassInMeasurement());
        performanceTestAnnotation.addPair("logFullData", "true");
        boolean useKiekerKoPeMe = this.config.getKiekerConfig().isUseKieker() && !this.config.getKiekerConfig().isDisableKiekerKoPeMe();
        performanceTestAnnotation.addPair("useKieker", "" + useKiekerKoPeMe);
        performanceTestAnnotation.addPair("timeout", this.config.getExecutionConfig().getTimeout() + "l");
        performanceTestAnnotation.addPair("repetitions", "" + this.config.getRepetitions());
        performanceTestAnnotation.addPair("redirectToNull", "" + this.config.getExecutionConfig().isRedirectToNull());
        performanceTestAnnotation.addPair("showStart", "" + this.config.getExecutionConfig().isShowStart());
        if (this.config.getKiekerConfig().getKiekerWaitTime() != 5) {
            performanceTestAnnotation.addPair("kiekerWaitTime", "" + this.config.getKiekerConfig().getKiekerWaitTime());
        }
        if (this.datacollectorlist.equals(DataCollectorList.ONLYTIME)) {
            performanceTestAnnotation.addPair("dataCollectors", "\"ONLYTIME\"");
        } else if (this.datacollectorlist.equals(DataCollectorList.ONLYTIME_NOGC)) {
            performanceTestAnnotation.addPair("dataCollectors", "\"ONLYTIME_NOGC\"");
        } else if (this.datacollectorlist.equals(DataCollectorList.NONE)) {
            performanceTestAnnotation.addPair("dataCollectors", "\"NONE\"");
        }
        method.addAnnotation((AnnotationExpr)performanceTestAnnotation);
    }
}

