/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.testtransformation;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import de.dagere.nodeDiffDetector.utils.JavaParserProvider;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.testtransformation.JUnitTestTransformer;
import de.dagere.peass.testtransformation.ParseUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimeBasedTestTransformer
extends JUnitTestTransformer {
    private static final int DEFAULT_DURATION = 60000;
    private static final Logger LOG = LogManager.getLogger(TimeBasedTestTransformer.class);
    private int duration = 60000;

    public TimeBasedTestTransformer(File path) {
        super(path, MeasurementConfig.DEFAULT);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    protected void editJUnit3(File javaFile) {
        try {
            CompilationUnit unit = JavaParserProvider.parse((File)javaFile);
            unit.addImport("de.dagere.kopeme.junit3.TimeBasedTestcase");
            for (ClassOrInterfaceDeclaration clazz : ParseUtil.getClasses(unit)) {
                if (clazz.getExtendedTypes(0).getNameAsString().equals("TestCase")) {
                    clazz.setExtendedTypes(new NodeList());
                    clazz.addExtendedType("TimeBasedTestcase");
                }
                this.addMethod(clazz, "logFullData", "return " + this.config.isLogFullData() + ";", (Type)PrimitiveType.booleanType());
                this.addMethod(clazz, "useKieker", "return " + this.config.getKiekerConfig().isUseKieker() + ";", (Type)PrimitiveType.booleanType());
                this.addMethod(clazz, "getDuration", "return " + this.duration + ";", (Type)PrimitiveType.longType());
                this.addMethod(clazz, "getMaximalTime", "return " + this.duration * 2 + ";", (Type)PrimitiveType.longType());
                this.addMethod(clazz, "getRepetitions", "return " + this.config.getRepetitions() + ";", (Type)PrimitiveType.intType());
            }
            Files.write(javaFile.toPath(), unit.toString().getBytes(this.charset), new OpenOption[0]);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void editJUnit4(File javaFile) {
        try {
            CompilationUnit unit = JavaParserProvider.parse((File)javaFile);
            unit.addImport("de.dagere.kopeme.annotations.Assertion");
            unit.addImport("de.dagere.kopeme.annotations.MaximalRelativeStandardDeviation");
            unit.addImport("de.dagere.kopeme.annotations.PerformanceTest");
            unit.addImport("de.dagere.kopeme.junit.testrunner.time.TimeBasedTestRunner");
            unit.addImport("org.junit.runner.RunWith");
            for (ClassOrInterfaceDeclaration clazz : ParseUtil.getClasses(unit)) {
                if (clazz.getAnnotations().size() > 0) {
                    boolean otherTestRunner = false;
                    for (AnnotationExpr annotation : clazz.getAnnotations()) {
                        if (!annotation.getNameAsString().contains("RunWith")) continue;
                        otherTestRunner = true;
                    }
                    if (otherTestRunner) {
                        return;
                    }
                }
                for (MethodDeclaration method : clazz.getMethods()) {
                    NormalAnnotationExpr performanceTestAnnotation = new NormalAnnotationExpr();
                    performanceTestAnnotation.setName("PerformanceTest");
                    performanceTestAnnotation.addPair("duration", "" + this.duration);
                    performanceTestAnnotation.addPair("logFullData", "true");
                    performanceTestAnnotation.addPair("timeout", "" + this.duration * 2);
                    performanceTestAnnotation.addPair("repetitions", "" + this.config.getRepetitions());
                    method.addAnnotation((AnnotationExpr)performanceTestAnnotation);
                }
                SingleMemberAnnotationExpr annotation = new SingleMemberAnnotationExpr();
                annotation.setName("RunWith");
                ClassExpr clazzExpression = new ClassExpr();
                clazzExpression.setType("TimeBasedTestRunner");
                annotation.setMemberValue((Expression)clazzExpression);
                clazz.addAnnotation((AnnotationExpr)annotation);
            }
            Files.write(javaFile.toPath(), unit.toString().getBytes(this.charset), new OpenOption[0]);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

