/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamGobbler
extends Thread {
    private static final Logger LOG = LogManager.getLogger(StreamGobbler.class);
    private final InputStream is;
    private final boolean showOutput;
    private final StringBuffer output;

    private StreamGobbler(InputStream is, boolean showOutput, StringBuffer output) {
        super("Gobbler");
        this.is = is;
        this.showOutput = showOutput;
        this.output = output;
    }

    @Override
    public void run() {
        try (InputStreamReader isr = new InputStreamReader(this.is);){
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (this.output != null) {
                    this.output.append(line);
                    this.output.append("\n");
                }
                if (!this.showOutput) continue;
                System.out.println(line);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void showFullProcess(Process process) {
        StreamGobbler.getFullProcess(process, true);
    }

    public static String getFullProcess(Process process, boolean showOutput) {
        StringBuffer output = new StringBuffer();
        StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), showOutput, output);
        StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), showOutput, output);
        outputGobbler.start();
        errorGobbler.start();
        LOG.trace("Waiting for process end");
        try {
            outputGobbler.join();
            errorGobbler.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        LOG.trace("Process finished");
        return output.toString();
    }
}

