/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.StatisticalSummaryValues;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class SummaryStatisticsDeserializer
extends StdDeserializer<StatisticalSummary> {
    private static final long serialVersionUID = -11534717009382554L;

    public SummaryStatisticsDeserializer() {
        super(StatisticalSummary.class);
    }

    public StatisticalSummary deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.isTextual()) {
            return new SummaryStatistics();
        }
        double mean = this.getDouble(node, "mean");
        double deviation = this.getDouble(node, "standardDeviation");
        int n = node.get("n").numberValue().intValue();
        double min = node.get("min").isNull() ? 0.0 : node.get("min").doubleValue();
        double max = node.get("max").isNull() ? 0.0 : node.get("max").doubleValue();
        return new StatisticalSummaryValues(mean, deviation * deviation, (long)n, max, min, mean * (double)n);
    }

    private double getDouble(JsonNode node, String fieldName) {
        JsonNode field = node.get(fieldName);
        if (field.asText().equals("NaN")) {
            return Double.NaN;
        }
        return field.doubleValue();
    }
}

