/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.vcs;

import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.dependency.analysis.data.CommitDiff;
import java.io.File;
import java.util.List;

public abstract class CommitIterator {
    protected final File projectFolder;
    protected int commitIndex = 0;

    public CommitIterator(File projectFolder) {
        this.projectFolder = projectFolder;
    }

    public abstract int getSize();

    public int getRemainingSize() {
        return -1;
    }

    public abstract String getCommitName();

    public abstract String getPredecessor();

    public abstract boolean hasNextCommit();

    public abstract boolean goToNextCommit();

    public abstract boolean goToFirstCommit();

    public abstract boolean goTo0thCommit();

    public boolean goToNamedCommit(String name) {
        this.goToFirstCommit();
        while (!this.getCommitName().equals(name) && this.hasNextCommit()) {
            this.goToNextCommit();
        }
        return this.getCommitName().equals(name);
    }

    public abstract boolean isPredecessor(String var1);

    public abstract boolean goToPreviousCommit();

    public abstract CommitDiff getChangedClasses(File var1, List<File> var2, String var3, ExecutionConfig var4);

    public abstract List<String> getCommits();

    public boolean hasPreviousCommit() {
        return this.commitIndex > 0;
    }
}

