/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.vcs;

import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.parameters.ExecutionConfigMixin;
import de.dagere.peass.dependency.analysis.data.CommitDiff;
import de.dagere.peass.vcs.CommitIterator;
import de.dagere.peass.vcs.GitUtils;
import java.io.File;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

public class CommitIteratorGit
extends CommitIterator {
    private static final Logger LOG = LogManager.getLogger(CommitIteratorGit.class);
    private final List<String> commits;
    private final String previous;
    private final int previousIndex;
    @CommandLine.Mixin
    private ExecutionConfigMixin executionConfigMixin;

    public CommitIteratorGit(File projectFolder) {
        super(projectFolder);
        this.previous = GitUtils.getName("HEAD~1", projectFolder);
        this.commits = GitUtils.getCommits(projectFolder, false, this.executionConfigMixin.isLinearizeHistory());
        this.previousIndex = this.commits.indexOf(this.previous);
    }

    public CommitIteratorGit(File projectFolder, List<String> commits, String previousCommit) {
        super(projectFolder);
        this.commits = commits;
        this.previous = previousCommit;
        int index = -1;
        if (previousCommit != null) {
            for (int i = 0; i < commits.size(); ++i) {
                String testedCommit = commits.get(i);
                LOG.debug("Trying " + testedCommit);
                if (!testedCommit.equals(previousCommit)) continue;
                LOG.debug("{} equals {}, setting start index to {}", (Object)testedCommit, (Object)previousCommit, (Object)i);
                index = i;
            }
        }
        this.previousIndex = index;
        this.commitIndex = this.previousIndex + 1;
    }

    @Override
    public boolean goToFirstCommit() {
        this.commitIndex = 0;
        GitUtils.goToCommit(this.commits.get(0), this.projectFolder);
        return true;
    }

    @Override
    public boolean goToNextCommit() {
        ++this.commitIndex;
        String nextTag = this.commits.get(this.commitIndex);
        GitUtils.goToCommit(nextTag, this.projectFolder);
        return true;
    }

    @Override
    public boolean goToPreviousCommit() {
        if (this.commitIndex > 0) {
            --this.commitIndex;
            String nextTag = this.commits.get(this.commitIndex);
            GitUtils.goToCommit(nextTag, this.projectFolder);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNextCommit() {
        return this.commitIndex + 1 < this.commits.size();
    }

    @Override
    public String getCommitName() {
        return this.commits.get(this.commitIndex);
    }

    @Override
    public String getPredecessor() {
        return this.previous;
    }

    @Override
    public int getSize() {
        return this.commits.size();
    }

    @Override
    public int getRemainingSize() {
        return this.commits.size() - this.commitIndex;
    }

    @Override
    public boolean goTo0thCommit() {
        if (this.previousIndex != -1) {
            GitUtils.goToCommit(this.previous, this.projectFolder);
            this.commitIndex = this.previousIndex;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPredecessor(String lastRunningCommit) {
        return this.commits.get(this.commitIndex - 1).equals(lastRunningCommit);
    }

    @Override
    public CommitDiff getChangedClasses(File projectFolder, List<File> genericModules, String lastCommit, ExecutionConfig config) {
        CommitDiff diff = GitUtils.getChangedClasses(projectFolder, genericModules, lastCommit, config);
        return diff;
    }

    @Override
    public List<String> getCommits() {
        return this.commits;
    }
}

