/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.vcs;

import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.dependency.analysis.data.CommitDiff;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.dependencyprocessors.VersionComparator;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.utils.StreamGobbler;
import de.dagere.peass.vcs.GitCommit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GitUtils {
    private static final Logger LOG = LogManager.getLogger(GitUtils.class);

    private GitUtils() {
    }

    public static CommitComparatorInstance getCommitsForURL(String url, boolean linearizeHistory) throws IOException {
        CommitComparatorInstance comparator = null;
        boolean repoFound = false;
        if (System.getenv("PEASS_PROJECTS") != null) {
            System.out.println(url);
            String project = url.substring(url.lastIndexOf(47) + 1, url.lastIndexOf("."));
            File candidate = new File(System.getenv("PEASS_PROJECTS"), project);
            if (candidate.exists()) {
                repoFound = true;
                List<String> commits = GitUtils.getCommits(candidate, false, linearizeHistory);
                comparator = new CommitComparatorInstance(commits);
                VersionComparator.setVersions(commits);
            }
        }
        if (!repoFound && System.getenv("PEASS_REPOS") != null) {
            String repofolderName = System.getenv("PEASS_REPOS");
            File repoFolder = new File(repofolderName);
            File dependencyFolder = new File(repoFolder, "dependencies-final");
            String project = url.substring(url.lastIndexOf("/") + 1, url.lastIndexOf(46));
            File staticSelectionFile = new File(dependencyFolder, "staticTestSelection_" + project + ".json");
            LOG.debug("Searching: {}", (Object)staticSelectionFile);
            if (staticSelectionFile.exists()) {
                StaticTestSelection dependencies = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(staticSelectionFile, StaticTestSelection.class);
                VersionComparator.setDependencies(dependencies);
                comparator = new CommitComparatorInstance(dependencies);
                repoFound = true;
            }
        }
        if (!repoFound) {
            File tempDir = Files.createTempDirectory("gitTemp", new FileAttribute[0]).toFile();
            GitUtils.downloadProject(url, tempDir);
            List<String> commits = GitUtils.getCommits(tempDir, false, linearizeHistory);
            comparator = new CommitComparatorInstance(commits);
            VersionComparator.setVersions(commits);
            FileUtils.deleteDirectory((File)tempDir);
        }
        return comparator;
    }

    public static void clone(PeassFolders folders, File projectFolderTemp, String gitCryptKey) throws IOException {
        File projectFolder = folders.getProjectFolder();
        GitUtils.clone(projectFolderTemp, projectFolder, gitCryptKey);
    }

    private static void clone(File projectFolderDest, File projectFolderSource, String gitCryptKey) throws IOException {
        if (projectFolderDest.exists()) {
            throw new RuntimeException("Can not clone to existing folder: " + projectFolderDest.getAbsolutePath());
        }
        FileUtils.copyDirectory((File)projectFolderSource, (File)projectFolderDest);
    }

    public static void downloadProject(String url, File folder) {
        try {
            ProcessBuilder pb = new ProcessBuilder("git", "clone", url, folder.getAbsolutePath());
            LOG.debug("Command: {}", pb.command());
            Process p = pb.start();
            StreamGobbler.showFullProcess(p);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void filterList(String startcommit, String endcommit, List<String> commits) {
        LOG.info("Count of Commits: {}", (Object)commits.size());
        boolean beforeStart = startcommit != null;
        boolean afterEnd = false;
        LinkedList<String> notRelevantCommits = new LinkedList<String>();
        for (String commit : commits) {
            LOG.debug("Processing {} {} {}", (Object)commit, (Object)beforeStart, (Object)afterEnd);
            if (startcommit != null && commit.startsWith(startcommit)) {
                beforeStart = false;
            }
            if (beforeStart || afterEnd) {
                notRelevantCommits.add(commit);
            }
            if (endcommit == null || !commit.startsWith(endcommit)) continue;
            afterEnd = true;
            if (!beforeStart) continue;
            boolean startCommitExists = commits.stream().anyMatch(potentialStart -> potentialStart.startsWith(startcommit));
            if (startCommitExists) {
                throw new RuntimeException("Startcommit " + startcommit + " after endcommit " + endcommit);
            }
            throw new RuntimeException("Startcommit " + startcommit + " not found at all, but endcommit " + endcommit + " found");
        }
        LOG.debug("Removing: {}", (Object)notRelevantCommits.size());
        commits.removeAll(notRelevantCommits);
    }

    public static List<String> getCommits(File folder, String startcommit, String endcommit, boolean linearizeHistory) {
        List<String> commits = GitUtils.getCommits(folder, true, linearizeHistory);
        GitUtils.filterList(startcommit, endcommit, commits);
        return commits;
    }

    public static List<String> getCommits(File folder, boolean includeAllBranches, boolean linearizeHistory) {
        try {
            List<String> commitNames = !linearizeHistory ? GitUtils.getCommitNames(folder, includeAllBranches) : GitUtils.getLinearCommitNames(folder);
            return commitNames;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<GitCommit> getCommitMetadata(File folder, List<String> commitNames) throws IOException {
        List<GitCommit> commits = GitUtils.getCommitsMetadata(folder, commitNames);
        return commits;
    }

    private static List<String> getLinearCommitNames(File folder) {
        try {
            String oldestCommit;
            ProcessBuilder oldestCommitProcessbuilder = new ProcessBuilder("git", "log", "--reverse", "--pretty=tformat:%H");
            oldestCommitProcessbuilder.directory(folder);
            Process readOldestCommitProcess = oldestCommitProcessbuilder.start();
            try (BufferedReader readOldestCommitInput = new BufferedReader(new InputStreamReader(readOldestCommitProcess.getInputStream()));){
                oldestCommit = readOldestCommitInput.readLine().split(" ")[0];
            }
            LinkedList<String> ouputCommitList = new LinkedList<String>();
            ProcessBuilder commitProcessbuilder = new ProcessBuilder("git", "rev-list", "--ancestry-path", "--children", oldestCommit + "..HEAD");
            commitProcessbuilder.directory(folder);
            Process readCommitProcess = commitProcessbuilder.start();
            try (BufferedReader readCommitInput = new BufferedReader(new InputStreamReader(readCommitProcess.getInputStream()));){
                String line;
                String lastChild = null;
                while ((line = readCommitInput.readLine()) != null) {
                    String[] ancestryHashes = line.split(" ");
                    HashSet<String> hashes = new HashSet<String>(Arrays.asList(ancestryHashes));
                    if (lastChild != null && !hashes.contains(lastChild)) continue;
                    ouputCommitList.add(0, ancestryHashes[0]);
                    lastChild = ancestryHashes[0];
                }
            }
            ouputCommitList.add(0, oldestCommit);
            return ouputCommitList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<GitCommit> getCommitsMetadata(File folder, List<String> commitNames) throws IOException {
        LinkedList<GitCommit> commits = new LinkedList<GitCommit>();
        for (String commit : commitNames) {
            ProcessBuilder readCommitProcessBuilder = new ProcessBuilder("git", "log", "--date=iso", "-n", "1", commit);
            readCommitProcessBuilder.directory(folder);
            Process readCommitProcess = readCommitProcessBuilder.start();
            try (BufferedReader readCommitInput = new BufferedReader(new InputStreamReader(readCommitProcess.getInputStream()));){
                String line = null;
                String author = null;
                String date = null;
                Object message = "";
                while ((line = readCommitInput.readLine()) != null) {
                    if (line.startsWith("Author:")) {
                        author = line.substring(8);
                    }
                    if (line.startsWith("Date: ")) {
                        date = line.substring(8);
                        continue;
                    }
                    if (author == null || date == null) continue;
                    message = (String)message + line + " ";
                }
                GitCommit gc = new GitCommit(commit, author, date, (String)message);
                commits.add(gc);
            }
        }
        return commits;
    }

    private static List<String> getCommitNames(File folder, boolean includeAllBranches) throws IOException {
        String command = includeAllBranches ? "git log --oneline --all --no-abbrev-commit" : "git log --oneline --no-abbrev-commit";
        Process p = Runtime.getRuntime().exec(command, new String[0], folder);
        try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            LinkedList<String> commitNames = new LinkedList<String>();
            while ((line = input.readLine()) != null) {
                String commit = line.split(" ")[0];
                commitNames.add(0, commit);
            }
            LinkedList<String> linkedList = commitNames;
            return linkedList;
        }
    }

    public static CommitDiff getChangedClasses(File projectFolder, List<File> modules, String lastCommit, ExecutionConfig config) {
        try {
            Process process = lastCommit != null ? Runtime.getRuntime().exec("git diff --name-only " + lastCommit + " HEAD", null, projectFolder) : Runtime.getRuntime().exec("git diff --name-only HEAD^ HEAD", null, projectFolder);
            return GitUtils.getDiffFromProcess(process, modules, projectFolder, config);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CommitDiff getChangedFiles(File projectFolder, List<File> modules, String commit, ExecutionConfig config) {
        try {
            Process process = Runtime.getRuntime().exec("git diff --name-only " + commit + ".." + commit + "~1", new String[0], projectFolder);
            return GitUtils.getDiffFromProcess(process, modules, projectFolder, config);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static CommitDiff getDiffFromProcess(Process p, List<File> modules, File projectFolder, ExecutionConfig config) {
        CommitDiff diff = new CommitDiff(modules, projectFolder);
        String output = StreamGobbler.getFullProcess(p, false);
        for (String line : output.split("\n")) {
            diff.addChange(line, config);
        }
        return diff;
    }

    public static int getChangedLines(File projectFolder, String commit, List<Type> entities, ExecutionConfig config) {
        try {
            File folderTemp = new File(FilenameUtils.normalize((String)projectFolder.getAbsolutePath()));
            String command = "git diff --stat=250 " + commit + ".." + commit + "~1";
            Process process = Runtime.getRuntime().exec(command, new String[0], folderTemp);
            String output = StreamGobbler.getFullProcess(process, false);
            int size = 0;
            String[] lines = output.split("\n");
            for (int index = 0; index < lines.length - 1; ++index) {
                Type changedEntity;
                String line = lines[index].trim().replaceAll("\\s{2,}", " ");
                System.out.println(line);
                String[] parts = line.split("\\|");
                String clazz = parts[0].replaceAll(" ", "");
                String number = parts[1];
                String countString = number.split(" ")[1];
                if (countString.equals("Bin")) continue;
                int count = Integer.parseInt(countString);
                String clazzName = GitUtils.getClazz(clazz, config);
                if (clazzName == null || !entities.contains(changedEntity = new Type(clazzName, ""))) continue;
                size += count;
            }
            return size;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String getClazz(String currentFileName, ExecutionConfig config) {
        if (currentFileName.endsWith(".java")) {
            String fileNameWithoutExtension = currentFileName.substring(0, currentFileName.length() - ".java".length());
            String containedPath = null;
            for (String path : config.getAllClazzFolders()) {
                if (!fileNameWithoutExtension.contains(path)) continue;
                containedPath = path;
                break;
            }
            if (containedPath != null) {
                int indexOf = currentFileName.indexOf(containedPath);
                String pathWithFolder = currentFileName.substring(indexOf);
                String classPath = CommitDiff.replaceClazzFolderFromName(pathWithFolder, containedPath);
                return classPath;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pull(File projectFolder) {
        File file = projectFolder;
        synchronized (file) {
            LOG.debug("Pulling {}", (Object)projectFolder.getAbsolutePath());
            try {
                Process pullProcess = Runtime.getRuntime().exec("git pull origin HEAD", new String[0], projectFolder);
                String out = StreamGobbler.getFullProcess(pullProcess, false);
                pullProcess.waitFor();
                LOG.debug(out);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void goToCommit(String commit, File projectFolder) {
        try {
            File file = projectFolder;
            synchronized (file) {
                LOG.debug("Going to commit {} folder: {}", (Object)commit, (Object)projectFolder.getAbsolutePath());
                GitUtils.reset(projectFolder);
                GitUtils.clean(projectFolder);
                int worked = GitUtils.checkout(commit, projectFolder);
                if (worked != 0) {
                    LOG.info("Return value was !=0 - fetching");
                    Process pFetch = Runtime.getRuntime().exec("git fetch --all", new String[0], projectFolder);
                    String outFetch = StreamGobbler.getFullProcess(pFetch, false);
                    pFetch.waitFor();
                    System.out.println(outFetch);
                    int secondCheckoutWorked = GitUtils.checkout(commit, projectFolder);
                    if (secondCheckoutWorked != 0) {
                        LOG.error("Second checkout did not work - an old commit is probably analyzed");
                    }
                }
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void clean(File projectFolder) throws IOException, InterruptedException {
        Process pClean = Runtime.getRuntime().exec("git clean -df", new String[0], projectFolder);
        String outClean = StreamGobbler.getFullProcess(pClean, false);
        pClean.waitFor();
        System.out.println(outClean);
    }

    public static void reset(File projectFolder) {
        try {
            Process pReset = Runtime.getRuntime().exec("git reset --hard", new String[0], projectFolder);
            String outReset = StreamGobbler.getFullProcess(pReset, false);
            pReset.waitFor();
            System.out.println(outReset);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static int checkout(String tag, File projectFolder) throws IOException, InterruptedException {
        String gitCommand = "git checkout -f " + tag;
        LOG.trace(gitCommand);
        Process pCheckout = Runtime.getRuntime().exec(gitCommand, new String[0], projectFolder);
        String outCheckout = StreamGobbler.getFullProcess(pCheckout, false);
        int worked = pCheckout.waitFor();
        System.out.println(outCheckout);
        if (outCheckout.toLowerCase().contains("smudge filter lfs failed")) {
            throw new RuntimeException("Checkout did not work. Smudge filter lfs failed");
        }
        return worked;
    }

    public static String getURL(File projectFolder) {
        try {
            Process process = Runtime.getRuntime().exec("git config --get remote.origin.url", new String[0], projectFolder);
            String url = StreamGobbler.getFullProcess(process, false).replace("\n", "");
            return url;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getName(String gitCommit, File projectFolder) {
        try {
            Process process = Runtime.getRuntime().exec("git rev-parse " + gitCommit, new String[0], projectFolder);
            String tag = StreamGobbler.getFullProcess(process, false).replace("\n", "");
            return tag;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized String getPrevious(String gitCommit, File projectFolder) {
        return GitUtils.getName(gitCommit + "~1", projectFolder);
    }

    public static String getCommitText(File projectFolder, String commit) {
        String text = "";
        try {
            String[] args2 = new String[]{"git", "log", "--pretty=format:%s %b", "-n", "1", commit};
            Process process = Runtime.getRuntime().exec(args2, new String[0], projectFolder);
            text = StreamGobbler.getFullProcess(process, false).replace("\n", "");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return text;
    }

    public static String getCommitter(File projectFolder, String commit) {
        String comitter = "";
        try {
            String[] args2 = new String[]{"git", "log", "--pretty=format:%aE %aN", "-n", "1", commit};
            Process process = Runtime.getRuntime().exec(args2, new String[0], projectFolder);
            comitter = StreamGobbler.getFullProcess(process, false).replace("\n", "");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return comitter;
    }

    public static int getVersions(File projectFolder) {
        try {
            Process process = Runtime.getRuntime().exec("git rev-list --all --count", new String[0], projectFolder);
            int count = Integer.parseInt(StreamGobbler.getFullProcess(process, false).replace("\n", ""));
            return count;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void unlockWithGitCrypt(File projectFolder, String gitCryptKey) {
        LOG.debug("GIT_CRYPT_KEY is set, unlocking: {}", (Object)projectFolder);
        ProcessBuilder processBuilder = new ProcessBuilder("git-crypt", "unlock", gitCryptKey);
        try {
            if (processBuilder.directory(projectFolder).start().waitFor() != 0) {
                LOG.error("GitCryptUnlock-Process did not exit with 0!");
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        if (!GitUtils.checkIsUnlockedWithGitCrypt(projectFolder)) {
            LOG.error("Folder is still locked, something went wrong!");
            throw new RuntimeException("Folder is still locked, something went wrong!");
        }
    }

    protected static boolean checkIsUnlockedWithGitCrypt(File projectFolder) {
        ProcessBuilder processBuilder = new ProcessBuilder("git", "config", "--local", "--get", "filter.git-crypt.smudge");
        processBuilder.directory(projectFolder);
        try {
            if (StreamGobbler.getFullProcess(processBuilder.start(), false).equals("\"git-crypt\" smudge\n")) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

