/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.vcs;

import java.io.File;
import java.io.IOException;

public enum VersionControlSystem {
    SVN,
    GIT;


    private static boolean parentFolderHasVCS(File folder, String vcsFileName) {
        File potentialVCSFile = new File(folder, vcsFileName);
        if (potentialVCSFile.exists()) {
            return true;
        }
        File parentFile = folder.getParentFile();
        if (parentFile != null) {
            return VersionControlSystem.parentFolderHasVCS(parentFile, vcsFileName);
        }
        return false;
    }

    public static File findVCSFolder(File folder) {
        try {
            return VersionControlSystem.findVCSFolder(folder.getCanonicalFile(), ".git");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File findVCSFolder(File folder, String vcsFileName) {
        File potentialVCSFile = new File(folder, vcsFileName);
        if (potentialVCSFile.exists()) {
            return folder;
        }
        File parentFile = folder.getParentFile();
        if (parentFile != null) {
            return VersionControlSystem.findVCSFolder(parentFile, vcsFileName);
        }
        return null;
    }

    public static VersionControlSystem getVersionControlSystem(File projectFolder) {
        try {
            if (VersionControlSystem.parentFolderHasVCS(projectFolder.getCanonicalFile(), ".svn")) {
                return SVN;
            }
            if (VersionControlSystem.parentFolderHasVCS(projectFolder.getCanonicalFile(), ".git")) {
                return GIT;
            }
            throw new RuntimeException("Unknown version control system type in " + projectFolder.getAbsolutePath() + " - .git and .svn not found");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

