/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependencyprocessors.CommitProcessor;
import de.dagere.peass.utils.StreamGobbler;
import de.dagere.peass.vcs.GitUtils;
import java.io.File;
import java.io.IOException;
import picocli.CommandLine;

@CommandLine.Command(description={"Starts running every commit just for downloading the dependencies. After all dependencies have been downloaded, most operations can be run locally (as long as the version control system can operate locally)."}, name="downloadDependencies")
public class CommitRunStarter
extends CommitProcessor {
    protected void processCommit(String version, CommitStaticSelection versioninfo) {
        GitUtils.goToCommit((String)version, (File)this.folders.getProjectFolder());
        try {
            Process p = Runtime.getRuntime().exec("mvn clean package -DskipTests=true", null, this.folders.getProjectFolder());
            StreamGobbler.showFullProcess((Process)p);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws JsonParseException, JsonMappingException, IOException {
        CommitRunStarter command = new CommitRunStarter();
        CommandLine commandLine = new CommandLine((Object)command);
        commandLine.execute(args);
        command.processCommandline();
    }
}

