/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass;

import de.dagere.kopeme.datastorage.JSONDataLoader;
import de.dagere.kopeme.kopemedata.DatacollectorResult;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.kopeme.kopemedata.VMResultChunk;
import de.dagere.peass.config.parameters.StatisticsConfigMixin;
import de.dagere.peass.measurement.dataloading.KoPeMeDataHelper;
import de.dagere.peass.measurement.statistics.data.DescribedChunk;
import java.io.File;
import java.io.FilenameFilter;
import java.util.concurrent.Callable;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(description={"Tells whether a change happened in a data folder"}, name="ischange")
public class IsChangeStarter
implements Callable<Integer> {
    private static final Logger LOG = LogManager.getLogger(IsChangeStarter.class);
    @CommandLine.Option(names={"-data", "--data"}, description={"Path to datafolder"})
    private File dataFolder;
    @CommandLine.Mixin
    protected StatisticsConfigMixin statisticConfigMixin;

    public static void main(String[] args) {
        IsChangeStarter command = new IsChangeStarter();
        CommandLine commandLine = new CommandLine((Object)command);
        System.exit(commandLine.execute(args));
    }

    @Override
    public Integer call() throws Exception {
        LOG.debug("Checking: {}", (Object)this.dataFolder);
        File xmlFile = this.dataFolder.listFiles((FilenameFilter)new WildcardFileFilter("*.json"))[0];
        Kopemedata data = JSONDataLoader.loadData((File)xmlFile);
        VMResultChunk chunk = (VMResultChunk)((DatacollectorResult)data.getFirstMethodResult().getDatacollectorResults().get(0)).getChunks().get(0);
        String[] commits = KoPeMeDataHelper.getCommits(chunk);
        LOG.debug(commits[1]);
        DescribedChunk describedChunk = new DescribedChunk(chunk, commits[0], commits[1]);
        boolean change = describedChunk.getStatistic(this.statisticConfigMixin.getStasticsConfig()).isChange();
        LOG.info("Change: {}", (Object)change);
        return change ? 1 : 0;
    }
}

