/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass;

import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.config.parameters.KiekerConfigMixin;
import de.dagere.peass.config.parameters.MeasurementConfigurationMixin;
import de.dagere.peass.config.parameters.StatisticsConfigMixin;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.SelectedTests;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.dependencyprocessors.PairProcessor;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.measurement.dependencyprocessors.DependencyTester;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import picocli.CommandLine;

@CommandLine.Command(description={"Measures the defined tests and commits until the number of VMs is reached"}, name="measure")
public class MeasureStarter
extends PairProcessor {
    @CommandLine.Mixin
    MeasurementConfigurationMixin measurementConfigMixin;
    @CommandLine.Mixin
    protected StatisticsConfigMixin statisticConfigMixin;
    @CommandLine.Mixin
    protected KiekerConfigMixin kiekerConfigMixin;
    @CommandLine.Option(names={"-test", "--test"}, description={"Name of the test to execute"})
    String testName;
    private static final Logger LOG = LogManager.getLogger(MeasureStarter.class);
    protected DependencyTester tester;
    private final List<String> commits = new LinkedList<String>();
    private int startindex;
    private int endindex;
    private TestMethodCall test;

    public Void call() throws Exception {
        super.call();
        MeasurementConfig measurementConfiguration = this.createConfig();
        this.createTester(measurementConfiguration);
        if (this.testName != null) {
            this.test = TestMethodCall.createFromString((String)this.testName);
            LOG.info("Test: {}", (Object)this.test);
        } else {
            this.test = null;
        }
        this.commits.add(this.staticTestSelection.getInitialcommit().getCommit());
        this.staticTestSelection.getCommits().keySet().forEach(commit -> this.commits.add((String)commit));
        this.startindex = this.getStartCommitIndex();
        this.endindex = this.getEndCommitIndex();
        this.processCommandline();
        return null;
    }

    private void createTester(MeasurementConfig measurementConfiguration) {
        if (this.measurementConfigMixin.getDuration() != 0) {
            throw new RuntimeException("Time-based running currently not supported; eventually fix commented-out code to get it running again");
        }
        EnvironmentVariables env = new EnvironmentVariables(measurementConfiguration.getExecutionConfig().getProperties());
        CommitComparatorInstance comparator = new CommitComparatorInstance((SelectedTests)this.staticTestSelection);
        this.tester = new DependencyTester(this.folders, measurementConfiguration, env, comparator);
    }

    private MeasurementConfig createConfig() {
        MeasurementConfig measurementConfiguration = new MeasurementConfig(this.measurementConfigMixin, this.executionMixin, this.statisticConfigMixin, this.kiekerConfigMixin);
        return measurementConfiguration;
    }

    private int getStartCommitIndex() {
        int currentStartindex;
        int n = currentStartindex = this.startcommit != null ? this.commits.indexOf(this.startcommit) : 0;
        if (this.executionData != null && this.startcommit != null && currentStartindex == -1) {
            String potentialStart = "";
            if (this.executionData.getCommits().containsKey(this.startcommit)) {
                for (String executionCommit : this.executionData.getCommits().keySet()) {
                    for (String dependencyCommit : this.staticTestSelection.getCommits().keySet()) {
                        if (!dependencyCommit.equals(executionCommit)) continue;
                        potentialStart = dependencyCommit;
                        break;
                    }
                    if (!executionCommit.equals(this.startcommit)) continue;
                    break;
                }
            }
            LOG.debug("Commit only in executefile, next commit in static selection file: {}", (Object)potentialStart);
            currentStartindex = this.commits.indexOf(potentialStart);
            if (currentStartindex == -1) {
                throw new RuntimeException("Did not find " + this.startcommit + " in given PRONTO-files!");
            }
        }
        return currentStartindex;
    }

    private int getEndCommitIndex() {
        int currentEndindex;
        int n = currentEndindex = this.endcommit != null ? this.commits.indexOf(this.endcommit) : this.commits.size();
        if (this.executionData != null && this.endcommit != null && currentEndindex == -1) {
            String potentialStart = "";
            if (this.executionData.getCommits().containsKey(this.endcommit)) {
                for (String executionCommit : this.executionData.getCommits().keySet()) {
                    boolean next = false;
                    for (String dependencyCommit : this.staticTestSelection.getCommits().keySet()) {
                        if (next) {
                            potentialStart = dependencyCommit;
                            break;
                        }
                        if (!dependencyCommit.equals(executionCommit)) continue;
                        next = true;
                    }
                    if (!executionCommit.equals(this.endcommit)) continue;
                    break;
                }
            }
            LOG.debug("Version only in executionfile, next commit in static selection file: {}", (Object)potentialStart);
            currentEndindex = this.commits.indexOf(potentialStart);
        }
        return currentEndindex;
    }

    protected void processCommit(String commit, CommitStaticSelection commitinfo) {
        LOG.debug("Configuration: VMs: {} Warmup: {} Iterations: {} Repetitions: {}", (Object)this.measurementConfigMixin.getVms(), (Object)this.measurementConfigMixin.getWarmup(), (Object)this.measurementConfigMixin.getIterations(), (Object)this.measurementConfigMixin.getRepetitions());
        try {
            int currentIndex = this.commits.indexOf(commit);
            boolean executeThisCommit = currentIndex >= this.startindex && currentIndex <= this.endindex;
            LOG.trace("Processing Commit {} Executing Tests: {}", (Object)commit, (Object)executeThisCommit);
            Set testcases = commitinfo.getTests().getTestMethods();
            String commitOld = commitinfo.getPredecessor();
            for (TestMethodCall testcase : testcases) {
                if (executeThisCommit && this.lastTestcaseCalls.containsKey(testcase)) {
                    boolean executeThisTest = true;
                    if (this.test != null) {
                        executeThisTest = this.checkTestName((TestCase)testcase, executeThisTest);
                    }
                    if (executeThisTest) {
                        executeThisTest = this.checkExecutionData(commit, testcase, executeThisTest);
                    }
                    if (executeThisTest) {
                        this.tester.setCommits(commit, commitOld);
                        this.tester.evaluate(testcase);
                    }
                }
                this.lastTestcaseCalls.put(testcase, commit);
            }
        }
        catch (IOException | InterruptedException | XmlPullParserException e) {
            e.printStackTrace();
        }
    }

    protected void postEvaluate() {
        this.tester.postEvaluate();
    }

    public boolean checkExecutionData(String commit, TestMethodCall testcase, boolean executeThisTest) {
        if (this.executionData != null) {
            TestSet calls = (TestSet)this.executionData.getCommits().get(commit);
            boolean hasChanges = false;
            if (calls != null) {
                for (Map.Entry clazzCalls : calls.entrySet()) {
                    String changedClazz = ((TestClazzCall)clazzCalls.getKey()).getClazz();
                    if (!changedClazz.equals(testcase.getClazz()) || !((Set)clazzCalls.getValue()).contains(testcase.getMethodWithParams())) continue;
                    hasChanges = true;
                }
            }
            if (!hasChanges) {
                LOG.debug("Skipping {} because of execution-JSON in {}", (Object)testcase, (Object)commit);
                executeThisTest = false;
            }
        }
        return executeThisTest;
    }

    public boolean checkTestName(TestCase testcase, boolean executeThisTest) {
        LOG.debug("Checking {} + {}", (Object)this.test, (Object)testcase);
        if (!this.test.equals((Object)testcase)) {
            executeThisTest = false;
            LOG.debug("Skipping: {}", (Object)testcase);
        } else {
            LOG.debug("Success!");
        }
        return executeThisTest;
    }

    public static void main(String[] args) {
        MeasureStarter command = new MeasureStarter();
        CommandLine commandLine = new CommandLine((Object)command);
        System.exit(commandLine.execute(args));
    }
}

