/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass;

import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.CauseSearchFolders;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.rca.CausePersistenceManager;
import de.dagere.peass.measurement.rca.CauseTester;
import de.dagere.peass.measurement.rca.LevelManager;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.data.CauseSearchData;
import de.dagere.peass.measurement.rca.kieker.BothTreeReader;
import de.dagere.peass.measurement.rca.searcher.LevelCauseSearcher;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.vcs.GitUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(description={"Continues root-cause-analysis based on existing treefile"}, name="continuerca")
public class RCALevelContinueStarter
implements Callable<Void> {
    private static final Logger LOG = LogManager.getLogger(RCALevelContinueStarter.class);
    @CommandLine.Option(names={"-folder", "--folder"}, description={"Folder of the project that should be analyzed"}, required=true)
    protected File projectFolder;

    public static void main(String[] args) {
        RCALevelContinueStarter command = new RCALevelContinueStarter();
        CommandLine commandLine = new CommandLine((Object)command);
        commandLine.execute(args);
    }

    @Override
    public Void call() throws Exception {
        CauseSearchFolders folders = new CauseSearchFolders(this.projectFolder);
        File resultFile = this.getResultFile(folders);
        File resultFileFull = this.getFullResultFile(folders);
        if (resultFile != null && resultFileFull != null) {
            CauseSearchData data = (CauseSearchData)Constants.OBJECTMAPPER.readValue(resultFile, CauseSearchData.class);
            CauseSearchData dataFull = (CauseSearchData)Constants.OBJECTMAPPER.readValue(resultFileFull, CauseSearchData.class);
            MeasurementConfig measurementConfig = data.getMeasurementConfig();
            CauseSearchFolders alternateFolders = this.createAlternateFolders(folders, measurementConfig.getExecutionConfig().getGitCryptKey());
            BothTreeReader reader = new BothTreeReader(data.getCauseConfig(), measurementConfig, folders, new EnvironmentVariables(measurementConfig.getExecutionConfig().getProperties()));
            reader.readCachedTrees();
            CausePersistenceManager persistenceManager = new CausePersistenceManager(data, dataFull, alternateFolders);
            List commits = GitUtils.getCommits((File)folders.getProjectFolder(), (boolean)true, (boolean)true);
            CommitComparatorInstance comparator = new CommitComparatorInstance(commits);
            EnvironmentVariables emptyEnv = new EnvironmentVariables();
            CauseTester measurer = new CauseTester(alternateFolders, measurementConfig, data.getCauseConfig(), emptyEnv, comparator);
            LevelCauseSearcher tester = new LevelCauseSearcher(measurer, persistenceManager, emptyEnv);
            LinkedList<CallTreeNode> currentCommitNodeList = new LinkedList<CallTreeNode>();
            LinkedList<CallTreeNode> currentPredecessorNodeList = new LinkedList<CallTreeNode>();
            new LevelManager(currentCommitNodeList, currentPredecessorNodeList, reader).goToLastMeasuredLevel(data.getNodes());
            tester.isLevelDifferent(currentPredecessorNodeList, currentCommitNodeList);
        }
        return null;
    }

    private CauseSearchFolders createAlternateFolders(CauseSearchFolders folders, String gitCryptKey) throws InterruptedException, IOException {
        File nowFolder = new File(folders.getTempProjectFolder(), "continue");
        GitUtils.clone((PeassFolders)folders, (File)nowFolder, (String)gitCryptKey);
        CauseSearchFolders alternateFolders = new CauseSearchFolders(nowFolder);
        return alternateFolders;
    }

    private File getResultFile(CauseSearchFolders folders) {
        File resultFile = null;
        for (File commitFolder : folders.getRcaTreeFolder().listFiles()) {
            for (File testcaseFolder : commitFolder.listFiles()) {
                for (File treeFile : testcaseFolder.listFiles()) {
                    if (!treeFile.getName().endsWith(".json")) continue;
                    resultFile = treeFile;
                }
            }
        }
        return resultFile;
    }

    private File getFullResultFile(CauseSearchFolders folders) {
        File resultFile = null;
        for (File commitFolder : folders.getRcaTreeFolder().listFiles()) {
            for (File testcaseFolder : commitFolder.listFiles()) {
                File detailsFolder = new File(testcaseFolder, "details");
                for (File treeFile : detailsFolder.listFiles()) {
                    if (!treeFile.getName().endsWith(".json")) continue;
                    resultFile = treeFile;
                }
            }
        }
        return resultFile;
    }
}

