/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.MeasureStarter;
import de.dagere.peass.analysis.properties.ChangedMethodManager;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.config.WorkloadType;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.SelectedTests;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.CauseSearchFolders;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.CauseSearcherConfigMixin;
import de.dagere.peass.measurement.rca.CauseTester;
import de.dagere.peass.measurement.rca.RCAStrategy;
import de.dagere.peass.measurement.rca.analyzer.SourceChangeTreeAnalyzer;
import de.dagere.peass.measurement.rca.analyzer.StructureChangeTreeAnalyzer;
import de.dagere.peass.measurement.rca.analyzer.TreeAnalyzer;
import de.dagere.peass.measurement.rca.kieker.BothTreeReader;
import de.dagere.peass.measurement.rca.searcher.CauseSearcher;
import de.dagere.peass.measurement.rca.searcher.CauseSearcherComplete;
import de.dagere.peass.measurement.rca.searcher.ICauseSearcher;
import de.dagere.peass.measurement.rca.searcher.LevelCauseSearcher;
import de.dagere.peass.measurement.rca.searcher.SamplingCauseSearcher;
import de.dagere.peass.measurement.rca.searcher.TreeAnalyzerCreator;
import java.io.File;
import java.io.IOException;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(description={"Searches for root cause of a performance change, i.e. method causing the performance change"}, name="searchcause")
public class SearchCauseStarter
extends MeasureStarter {
    private static final Logger LOG = LogManager.getLogger(SearchCauseStarter.class);
    @CommandLine.Mixin
    private CauseSearcherConfigMixin causeSearchConfigMixin;

    public static void main(String[] args) {
        SearchCauseStarter command = new SearchCauseStarter();
        CommandLine commandLine = new CommandLine((Object)command);
        System.exit(commandLine.execute(args));
    }

    @Override
    public Void call() throws Exception {
        if (this.testName == null) {
            throw new RuntimeException("Test needs to be defined!");
        }
        this.initCommitProcessor();
        if (this.commit == null) {
            this.commit = (String)this.executionData.getCommits().keySet().iterator().next();
            LOG.info("Commit was not defined, using {}", (Object)this.commit);
        }
        TestMethodCall test = this.determineTest();
        String predecessor = ((CommitStaticSelection)this.staticTestSelection.getCommits().get(this.commit)).getPredecessor();
        LOG.debug("Timeout in minutes: {}", (Object)this.executionMixin.getTimeout());
        MeasurementConfig measurementConfiguration = this.getConfiguration(predecessor);
        CauseSearcherConfig causeSearcherConfig = new CauseSearcherConfig(test, this.causeSearchConfigMixin);
        if (!this.kiekerConfigMixin.isNotUseAggregation() && measurementConfiguration.getKiekerConfig().getRecord() == AllowedKiekerRecord.OPERATIONEXECUTION) {
            throw new RuntimeException("Aggregation and OperationExecutionRecord can not be combined!");
        }
        if (this.kiekerConfigMixin.isNotUseAggregation() && measurementConfiguration.getKiekerConfig().getRecord() == AllowedKiekerRecord.DURATION) {
            throw new RuntimeException("Non-aggregation and duration record cannot be combined, since duration records make it impossible to detect place in call tree");
        }
        if (this.kiekerConfigMixin.isNotUseAggregation() && measurementConfiguration.getExecutionConfig().isUseAnbox()) {
            throw new RuntimeException("Non-aggregation and Anbox cannot be combined");
        }
        CauseSearchFolders alternateFolders = new CauseSearchFolders(this.folders.getProjectFolder());
        BothTreeReader reader = new BothTreeReader(causeSearcherConfig, measurementConfiguration, alternateFolders, new EnvironmentVariables(measurementConfiguration.getExecutionConfig().getProperties()));
        CommitComparatorInstance comparator = new CommitComparatorInstance((SelectedTests)this.staticTestSelection);
        ICauseSearcher tester = SearchCauseStarter.getCauseSeacher(measurementConfiguration, causeSearcherConfig, alternateFolders, reader, comparator);
        tester.search();
        return null;
    }

    private TestMethodCall determineTest() {
        TestMethodCall test = TestMethodCall.createFromString((String)this.testName);
        CommitStaticSelection commitInfo = (CommitStaticSelection)this.staticTestSelection.getCommits().get(this.commit);
        boolean found = false;
        for (TestMethodCall selectedTest : commitInfo.getTests().getTestMethods()) {
            if (!selectedTest.getClazz().equals(test.getClazz()) || !selectedTest.getMethodWithParams().equals(test.getMethodWithParams())) continue;
            found = true;
            test = selectedTest;
        }
        if (!found) {
            LOG.error("Test {} is not contained in regression test selection result, therefore it is unlikely to have a performance change!", (Object)test);
        }
        return test;
    }

    private MeasurementConfig getConfiguration(String predecessor) {
        MeasurementConfig measurementConfiguration = new MeasurementConfig(this.measurementConfigMixin, this.executionMixin, this.statisticConfigMixin, this.kiekerConfigMixin);
        measurementConfiguration.getKiekerConfig().setUseKieker(true);
        measurementConfiguration.getFixedCommitConfig().setCommit(this.commit);
        measurementConfiguration.getFixedCommitConfig().setCommitOld(predecessor);
        if (this.causeSearchConfigMixin.getStrategy().equals((Object)RCAStrategy.COMPLETE)) {
            measurementConfiguration.getKiekerConfig().setEnableAdaptiveMonitoring(false);
        } else {
            boolean useSourceInstrumentation = measurementConfiguration.getKiekerConfig().isUseSourceInstrumentation();
            measurementConfiguration.getKiekerConfig().setEnableAdaptiveMonitoring(!useSourceInstrumentation);
        }
        if (this.kiekerConfigMixin.isNotUseSourceInstrumentation() && this.kiekerConfigMixin.isNotUseSelectiveInstrumentation()) {
            measurementConfiguration.getKiekerConfig().setUseSelectiveInstrumentation(false);
        } else {
            measurementConfiguration.getKiekerConfig().setUseSelectiveInstrumentation(true);
        }
        if (this.kiekerConfigMixin.isNotUseSourceInstrumentation() && measurementConfiguration.getExecutionConfig().getTestTransformer().equals(WorkloadType.JMH.getTestTransformer())) {
            throw new RuntimeException("AspectJ instrumentation and jmh currently not implemented!");
        }
        LOG.info("Use source instrumentation: {}", (Object)this.kiekerConfigMixin.isNotUseSourceInstrumentation());
        return measurementConfiguration;
    }

    public static ICauseSearcher getCauseSeacher(final MeasurementConfig measurementConfiguration, CauseSearcherConfig causeSearcherConfig, CauseSearchFolders alternateFolders, BothTreeReader reader, CommitComparatorInstance comparator) throws IOException, InterruptedException {
        CauseSearcher tester;
        block11: {
            CauseTester measurer;
            EnvironmentVariables env;
            block10: {
                if (measurementConfiguration.getKiekerConfig().isOnlyOneCallRecording()) {
                    throw new RuntimeException("isOnlyOneCallRecording is not allowed to be set to true for RCA!");
                }
                if (measurementConfiguration.isDirectlyMeasureKieker()) {
                    throw new RuntimeException("directlyMeasureKieker is not allowed to be set to true for RCA!");
                }
                env = reader.getEnv();
                measurer = new CauseTester(alternateFolders, measurementConfiguration, causeSearcherConfig, env, comparator);
                if (causeSearcherConfig.getRcaStrategy() == null) break block10;
                switch (causeSearcherConfig.getRcaStrategy()) {
                    case COMPLETE: {
                        tester = new CauseSearcherComplete(reader, causeSearcherConfig, measurer, measurementConfiguration, alternateFolders, env);
                        break block11;
                    }
                    case LEVELWISE: {
                        tester = new LevelCauseSearcher(reader, causeSearcherConfig, measurer, measurementConfiguration, alternateFolders, env);
                        break block11;
                    }
                    case UNTIL_SOURCE_CHANGE: {
                        if (causeSearcherConfig.getPropertyFolder() == null) {
                            throw new RuntimeException("Property folder with correct source code needs to be defined if strategy is UNTIL_SOURCE_CHANGE!");
                        }
                        TreeAnalyzerCreator creatorSource = new TreeAnalyzerCreator(){

                            @Override
                            public TreeAnalyzer getAnalyzer(BothTreeReader reader, CauseSearcherConfig config) {
                                File propertyFolder = config.getPropertyFolder();
                                File methodSourceFolder = new File(propertyFolder, "methods");
                                ChangedMethodManager manager = new ChangedMethodManager(methodSourceFolder);
                                return new SourceChangeTreeAnalyzer(reader.getRootCurrent(), reader.getRootPredecessor(), manager, measurementConfiguration);
                            }
                        };
                        tester = new CauseSearcherComplete(reader, causeSearcherConfig, measurer, measurementConfiguration, alternateFolders, creatorSource, env);
                        break block11;
                    }
                    case UNTIL_STRUCTURE_CHANGE: {
                        TreeAnalyzerCreator creator = new TreeAnalyzerCreator(){

                            @Override
                            public TreeAnalyzer getAnalyzer(BothTreeReader reader, CauseSearcherConfig config) {
                                return new StructureChangeTreeAnalyzer(reader.getRootCurrent(), reader.getRootPredecessor());
                            }
                        };
                        tester = new CauseSearcherComplete(reader, causeSearcherConfig, measurer, measurementConfiguration, alternateFolders, creator, env);
                        break block11;
                    }
                    case SAMPLING: {
                        SamplingCauseSearcher tester2 = new SamplingCauseSearcher(causeSearcherConfig.getTestCase(), measurementConfiguration, (PeassFolders)alternateFolders, env);
                    }
                    default: {
                        throw new RuntimeException("Strategy " + String.valueOf((Object)causeSearcherConfig.getRcaStrategy()) + " not expected");
                    }
                }
            }
            LOG.info("Defaulting to StructureCauseSearcher");
            TreeAnalyzerCreator creator = new TreeAnalyzerCreator(){

                @Override
                public TreeAnalyzer getAnalyzer(BothTreeReader reader, CauseSearcherConfig config) {
                    return new StructureChangeTreeAnalyzer(reader.getRootCurrent(), reader.getRootPredecessor());
                }
            };
            tester = new CauseSearcherComplete(reader, causeSearcherConfig, measurer, measurementConfiguration, alternateFolders, creator, env);
        }
        return tester;
    }
}

