/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.analysis.changes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.analysis.changes.Change;
import de.dagere.peass.dependency.analysis.data.TestSet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Changes
implements Serializable {
    private static final long serialVersionUID = -7339774896217980704L;
    private Map<String, List<Change>> testcaseChanges = new TreeMap<String, List<Change>>();

    public Map<String, List<Change>> getTestcaseChanges() {
        return this.testcaseChanges;
    }

    public void setTestcaseChanges(Map<String, List<Change>> testcaseChanges) {
        this.testcaseChanges = testcaseChanges;
    }

    @JsonIgnore
    public Map<TestClazzCall, List<Change>> getTestcaseObjectChanges() {
        LinkedHashMap<TestClazzCall, List<Change>> resultChanges = new LinkedHashMap<TestClazzCall, List<Change>>();
        for (Map.Entry<String, List<Change>> testcaseEntry : this.testcaseChanges.entrySet()) {
            TestClazzCall test = TestClazzCall.createFromString((String)testcaseEntry.getKey());
            resultChanges.put(test, testcaseEntry.getValue());
        }
        return resultChanges;
    }

    public Change addChange(TestMethodCall testcase, String viewName, double oldTime, double percent, double tvalue, Double mannWhitheyUStatistic, long vms) {
        Change change = new Change();
        change.setDiff(viewName);
        change.setTvalue(tvalue);
        change.setMannWhitneyUStatistic(mannWhitheyUStatistic);
        change.setOldTime(oldTime);
        change.setChangePercent(percent);
        change.setVms(vms);
        change.setMethod(testcase.getMethod());
        change.setParams(testcase.getParams());
        String clazz = testcase.getTestclazzWithModuleName();
        this.addChange(clazz, change);
        return change;
    }

    public Change getChange(TestMethodCall test) {
        List<Change> changes = this.testcaseChanges.get(test.getClassWithModule());
        if (changes != null) {
            for (Change candidate : changes) {
                String testMethod;
                String candidateMethod = candidate.getMethod();
                if (!candidateMethod.equals(testMethod = test.getMethod())) continue;
                return candidate;
            }
        }
        return null;
    }

    public void addChange(String testclazz, Change change) {
        if (change == null) {
            throw new RuntimeException("Change should not be null! Testclass: " + testclazz);
        }
        List<Change> currentChanges = this.testcaseChanges.get(testclazz);
        if (currentChanges == null) {
            currentChanges = new LinkedList<Change>();
            this.testcaseChanges.put(testclazz, currentChanges);
        }
        boolean detectedEqualChange = false;
        for (Change existingChange : currentChanges) {
            if (!existingChange.getMethodWithParams().equals(change.getMethodWithParams())) continue;
            if (existingChange.getTvalue() * change.getTvalue() < 0.0) {
                throw new RuntimeException("Test method was measured twice: " + existingChange.getMethodWithParams() + " and t-value sign was differing: " + existingChange.getTvalue() + " vs " + change.getTvalue());
            }
            detectedEqualChange = true;
        }
        if (!detectedEqualChange) {
            currentChanges.add(change);
            currentChanges.sort(new Comparator<Change>(){

                @Override
                public int compare(Change o1, Change o2) {
                    return o1.getDiff().compareTo(o2.getDiff());
                }
            });
        }
    }

    @JsonIgnore
    public TestSet getTests() {
        TestSet result = new TestSet();
        for (Map.Entry<String, List<Change>> testclazz : this.testcaseChanges.entrySet()) {
            String clazzname = testclazz.getKey();
            for (Change method : testclazz.getValue()) {
                String methodName = method.getMethod();
                TestMethodCall testcase = TestMethodCall.createFromClassString((String)clazzname, (String)methodName);
                result.addTest(testcase);
            }
        }
        return result;
    }
}

