/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.analysis.changes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.analysis.changes.Change;
import de.dagere.peass.analysis.changes.ChangeProcessor;
import de.dagere.peass.analysis.changes.Changes;
import de.dagere.peass.config.StatisticsConfig;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.dependencyprocessors.VersionComparator;
import de.dagere.peass.measurement.statistics.Relation;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProjectChanges
implements Serializable {
    private static final long serialVersionUID = 5377574657253392155L;
    private static final Logger LOG = LogManager.getLogger(ProjectChanges.class);
    private int commitCount;
    private int changeCount;
    private int testcaseCount;
    private StatisticsConfig statisticsConfig;
    private Map<String, Changes> commitChanges = VersionComparator.hasVersions() ? new TreeMap(VersionComparator.INSTANCE) : new LinkedHashMap();

    public ProjectChanges() {
    }

    public ProjectChanges(CommitComparatorInstance comparator) {
        this.commitChanges = new TreeMap<String, Changes>((Comparator<String>)comparator);
    }

    public ProjectChanges(StatisticsConfig statisticsConfig, CommitComparatorInstance comparator) {
        this(comparator);
        this.statisticsConfig = statisticsConfig;
    }

    public StatisticsConfig getStatisticsConfig() {
        return this.statisticsConfig;
    }

    public void setStatisticsConfig(StatisticsConfig statisticsConfig) {
        this.statisticsConfig = statisticsConfig;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public void setCommitCount(int commits) {
        this.commitCount = commits;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public void setChangeCount(int changes) {
        this.changeCount = changes;
    }

    public int getTestcaseCount() {
        return this.testcaseCount;
    }

    public void setTestcaseCount(int testcases) {
        this.testcaseCount = testcases;
    }

    public Map<String, Changes> getCommitChanges() {
        return this.commitChanges;
    }

    public void setCommitChanges(Map<String, Changes> commitChanges) {
        this.commitChanges = commitChanges;
    }

    public void addChange(TestMethodCall testCase, String commit, Relation confidenceResult, Relation tTestResult, double oldTime, double diffPercent, double tvalue, double mannWhitheyUStatistic, long vms) {
        Changes changeList = this.getCommitChanges(commit);
        String viewName = "view_" + commit + "/diffs/" + testCase.getShortClazz() + "#" + testCase.getMethod() + ".txt";
        LOG.debug("Adding change: {} to {}", (Object)testCase, (Object)commit);
        changeList.addChange(testCase, viewName, oldTime, diffPercent, tvalue, mannWhitheyUStatistic, vms);
        ++this.changeCount;
    }

    public void addChange(TestCase test, String commit, Change change) {
        Changes changeList = this.getCommitChanges(commit);
        String clazz = test.getTestclazzWithModuleName();
        changeList.addChange(clazz, change);
        ++this.changeCount;
    }

    @JsonIgnore
    public Changes getCommitChanges(String key) {
        Changes result = this.commitChanges.get(key);
        if (result == null) {
            result = new Changes();
            this.commitChanges.put(key, result);
        }
        return result;
    }

    public void executeProcessor(ChangeProcessor c) {
        for (Map.Entry<String, Changes> commit : this.commitChanges.entrySet()) {
            for (Map.Entry<String, List<Change>> testcase : commit.getValue().getTestcaseChanges().entrySet()) {
                for (Change change : testcase.getValue()) {
                    c.process(commit.getKey(), testcase.getKey(), change);
                }
            }
        }
    }
}

