/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.analysis.measurement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.dependencyprocessors.CommitByNameComparator;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.dependencyprocessors.VersionComparator;
import de.dagere.peass.measurement.statistics.data.TestcaseStatistic;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProjectStatistics {
    private static final Logger LOG = LogManager.getLogger(ProjectStatistics.class);
    public Map<String, Map<TestMethodCall, TestcaseStatistic>> statistics = VersionComparator.hasVersions() ? new TreeMap(VersionComparator.INSTANCE) : new LinkedHashMap();

    public ProjectStatistics() {
        this.statistics = VersionComparator.hasVersions() ? new TreeMap(CommitByNameComparator.INSTANCE) : new LinkedHashMap();
    }

    public ProjectStatistics(CommitComparatorInstance comparator) {
        this.statistics = new TreeMap<String, Map<TestMethodCall, TestcaseStatistic>>((Comparator<String>)comparator);
    }

    public Map<String, Map<TestMethodCall, TestcaseStatistic>> getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Map<String, Map<TestMethodCall, TestcaseStatistic>> statistics) {
        this.statistics = statistics;
    }

    public void addMeasurement(String commit, TestMethodCall test, DescriptiveStatistics statisticsOld, DescriptiveStatistics statisticsCurrent, int calls) {
        TestcaseStatistic statistic = new TestcaseStatistic(statisticsOld, statisticsCurrent, (long)calls, (long)calls);
        this.addMeasurement(commit, test, statistic);
    }

    public void addMeasurement(String commit, TestMethodCall test, TestcaseStatistic statistic) {
        Map<TestMethodCall, TestcaseStatistic> commitMap = this.statistics.get(commit);
        if (commitMap == null) {
            commitMap = new TreeMap<TestMethodCall, TestcaseStatistic>();
            this.statistics.put(commit, commitMap);
        }
        if (commitMap.containsKey(test)) {
            LOG.error("Test " + String.valueOf(test) + " already executed in " + commit + " - two measurements!");
        }
        commitMap.put(test, statistic);
    }

    @JsonIgnore
    public int getTestCount() {
        int tests = 0;
        for (Map<TestMethodCall, TestcaseStatistic> commitStatistic : this.statistics.values()) {
            tests += commitStatistic.size();
        }
        return tests;
    }
}

