/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.analysis.measurement;

import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.peass.analysis.measurement.ProjectStatistics;
import de.dagere.peass.config.StatisticsConfig;
import de.dagere.peass.measurement.dataloading.MultipleVMTestUtil;
import de.dagere.peass.measurement.dataloading.ResultLoader;
import de.dagere.peass.measurement.statistics.ConfidenceIntervalInterpretion;
import de.dagere.peass.measurement.statistics.Relation;
import de.dagere.peass.measurement.statistics.StatisticUtil;
import de.dagere.peass.measurement.statistics.bimodal.CompareData;
import de.dagere.peass.measurement.statistics.data.EvaluationPair;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.inference.TestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestStatistic {
    private static final Logger LOG = LogManager.getLogger(TestStatistic.class);
    private final int diff;
    private final double tValue;
    private final double mannWhitneyUStatistic;
    private final boolean change;
    private final Relation confidenceResult;
    private final DescriptiveStatistics statisticsPrevious;
    private final DescriptiveStatistics statisticsCurrent;

    public TestStatistic(EvaluationPair data) {
        this(data, null, 0.01);
    }

    public TestStatistic(EvaluationPair data, ProjectStatistics info, double type1error) {
        List<VMResult> previous = ResultLoader.removeResultsWithWrongConfiguration(data.getPrevius());
        List<VMResult> current = ResultLoader.removeResultsWithWrongConfiguration(data.getCurrent());
        this.checkData(data, previous, current);
        previous = StatisticUtil.shortenValues(previous);
        current = StatisticUtil.shortenValues(current);
        CompareData cd = new CompareData(previous, current);
        this.confidenceResult = ConfidenceIntervalInterpretion.compare(cd);
        int resultslength = Math.min(data.getCurrent().size(), data.getPrevius().size());
        LOG.trace("Results: {}", (Object)resultslength);
        this.statisticsPrevious = ConfidenceIntervalInterpretion.getStatistics(previous);
        this.statisticsCurrent = ConfidenceIntervalInterpretion.getStatistics(current);
        List<Double> predecessor_double = MultipleVMTestUtil.getAverages(previous);
        List<Double> current_double = MultipleVMTestUtil.getAverages(current);
        double[] dataPredecessor = ArrayUtils.toPrimitive((Double[])predecessor_double.toArray(new Double[0]));
        double[] dataCurrent = ArrayUtils.toPrimitive((Double[])current_double.toArray(new Double[0]));
        DescriptiveStatistics dsPredecessor = new DescriptiveStatistics(dataPredecessor);
        DescriptiveStatistics dsCurrent = new DescriptiveStatistics(dataCurrent);
        LOG.trace(dsPredecessor.getMean() + " " + dsCurrent.getMean() + " " + dsPredecessor.getStandardDeviation() + " " + dsCurrent.getStandardDeviation());
        this.tValue = TestUtils.t((double[])dataPredecessor, (double[])dataCurrent);
        this.mannWhitneyUStatistic = StatisticUtil.getMannWhitneyUStatistic(dataPredecessor, dataCurrent);
        this.change = TestUtils.homoscedasticTTest((double[])dataPredecessor, (double[])dataCurrent, (double)type1error);
        this.diff = (int)((this.statisticsPrevious.getMean() - this.statisticsCurrent.getMean()) * 10000.0 / this.statisticsPrevious.getMean());
        LOG.trace("Means: {} {} Diff: {} % T-Value: {} Change: {}", (Object)this.statisticsPrevious.getMean(), (Object)this.statisticsCurrent.getMean(), (Object)((double)this.diff / 100.0), (Object)this.tValue, (Object)this.change);
        this.addToInfo(data, info, resultslength);
    }

    public TestStatistic(EvaluationPair data, ProjectStatistics info, StatisticsConfig config) {
        this(data, info, config.getType1error());
    }

    private void addToInfo(EvaluationPair data, ProjectStatistics info, int resultslength) {
        if (info != null) {
            info.addMeasurement(data.getCommit(), data.getTestcase(), this.statisticsPrevious, this.statisticsCurrent, resultslength);
        }
    }

    private void checkData(EvaluationPair data, List<VMResult> previous, List<VMResult> current) {
        if (previous.size() == 0 || current.size() == 0) {
            LOG.error("Data empty: {} {}", (Object)data.getCommit());
            if (previous.size() == 0) {
                LOG.error("Previous  empty");
            }
            if (current.size() == 0) {
                LOG.error("Previous  empty");
            }
            throw new RuntimeException("Data of " + String.valueOf(data.getTestcase()) + " empty");
        }
        if (Double.isNaN(current.get(0).getDeviation()) || Double.isNaN(previous.get(0).getDeviation())) {
            throw new RuntimeException("Data contained NaN - not handling result");
        }
    }

    public boolean isChange() {
        return this.change;
    }

    public int getDiff() {
        return this.diff;
    }

    public double getTValue() {
        return this.tValue;
    }

    public Relation getConfidenceResult() {
        return this.confidenceResult;
    }

    public DescriptiveStatistics getPreviousStatistic() {
        return this.statisticsPrevious;
    }

    public DescriptiveStatistics getCurrentStatistic() {
        return this.statisticsCurrent;
    }

    public String toString() {
        return this.tValue + " " + this.getStatisticString(this.statisticsPrevious) + " " + this.getStatisticString(this.statisticsCurrent);
    }

    private String getStatisticString(DescriptiveStatistics statistics) {
        return statistics.getMean() + " " + statistics.getStandardDeviation() / statistics.getMean();
    }

    public Double getMannWhitneyUStatistic() {
        return this.mannWhitneyUStatistic;
    }
}

