/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.cleaning;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.peass.dependency.persistence.SelectedTests;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.measurement.cleaning.Cleaner;
import de.dagere.peass.measurement.dataloading.CommitSorter;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="clean", description={"Cleans the data for faster analysis and transfer"}, mixinStandardHelpOptions=true)
public class CleanStarter
implements Callable<Void> {
    private static final Logger LOG = LogManager.getLogger(CleanStarter.class);
    @CommandLine.Option(names={"-staticSelectionFile", "--staticSelectionFile"}, description={"Path to the staticSelectionFile"})
    protected File staticSelectionFile;
    @CommandLine.Option(names={"-executionFile", "--executionFile"}, description={"Path to the executionfile"})
    protected File executionfile;
    @CommandLine.Option(names={"-data", "--data"}, description={"Path to datafolder"})
    protected File[] data;

    public static void main(String[] args) throws JsonParseException, JsonMappingException, IOException {
        CommandLine commandLine = new CommandLine((Object)new CleanStarter());
        System.exit(commandLine.execute(args));
    }

    @Override
    public Void call() throws Exception {
        SelectedTests tests = CommitSorter.getSelectedTests(this.staticSelectionFile, this.executionfile, new File[0]);
        CommitComparatorInstance comparator = new CommitComparatorInstance(tests);
        for (int i = 0; i < this.data.length; ++i) {
            File folder = this.data[i];
            if (folder.getName().endsWith("_peass")) {
                folder = new File(folder, "measurementsFull");
            }
            if (!folder.exists()) {
                throw new RuntimeException("Folder " + String.valueOf(folder) + " did not exist");
            }
            LOG.info("Searching in " + String.valueOf(folder));
            File cleanFolder = new File(folder.getParentFile(), "clean");
            cleanFolder.mkdirs();
            File projectFolderName = new File(cleanFolder, folder.getName());
            if (projectFolderName.exists()) {
                throw new RuntimeException("Clean already finished - delete " + projectFolderName.getAbsolutePath() + ", if you want to clean!");
            }
            projectFolderName.mkdirs();
            Cleaner transformer = new Cleaner(projectFolderName, comparator);
            LOG.info("Start");
            transformer.processDataFolder(folder);
            LOG.info("Finish");
        }
        return null;
    }
}

