/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.cleaning;

import de.dagere.kopeme.datastorage.JSONDataStorer;
import de.dagere.kopeme.kopemedata.DatacollectorResult;
import de.dagere.kopeme.kopemedata.Fulldata;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.kopeme.kopemedata.VMResultChunk;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.measurement.dataloading.DataAnalyser;
import de.dagere.peass.measurement.dataloading.MeasurementFileFinder;
import de.dagere.peass.measurement.dataloading.MultipleVMTestUtil;
import de.dagere.peass.measurement.statistics.StatisticUtil;
import de.dagere.peass.measurement.statistics.data.EvaluationPair;
import de.dagere.peass.measurement.statistics.data.TestData;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cleaner
extends DataAnalyser {
    private static final Logger LOG = LogManager.getLogger(Cleaner.class);
    private final File cleanFolder;
    private int correct = 0;
    protected int read = 0;

    public int getCorrect() {
        return this.correct;
    }

    public int getRead() {
        return this.read;
    }

    public Cleaner(File cleanFolder, CommitComparatorInstance comparator) {
        super(comparator);
        this.cleanFolder = cleanFolder;
    }

    @Override
    public void processTestdata(TestData measurementEntry) {
        for (Map.Entry<String, EvaluationPair> entry : measurementEntry.getMeasurements().entrySet()) {
            ++this.read;
            this.cleanTestVersionPair(entry);
        }
    }

    public void cleanTestVersionPair(Map.Entry<String, EvaluationPair> entry) {
        TestMethodCall testcase = entry.getValue().getTestcase();
        if (entry.getValue().getPrevius().size() >= 2 && entry.getValue().getCurrent().size() >= 2) {
            VMResultChunk cleanedChunk = new VMResultChunk();
            long minExecutionCount = MultipleVMTestUtil.getMinIterationCount(entry.getValue().getPrevius());
            List<VMResult> previous = this.getChunk(entry.getValue().getPreviousCommit(), minExecutionCount, entry.getValue().getPrevius());
            cleanedChunk.getResults().addAll(previous);
            List<VMResult> current = this.getChunk(entry.getValue().getCommit(), minExecutionCount, entry.getValue().getCurrent());
            cleanedChunk.getResults().addAll(current);
            long chunkStartTime = this.getChunkStartTime(previous, current);
            cleanedChunk.setChunkStartTime(chunkStartTime);
            this.handleChunk(entry, testcase, cleanedChunk);
        }
    }

    private long getChunkStartTime(List<VMResult> previous, List<VMResult> current) {
        long chunkStartTime = Long.MAX_VALUE;
        for (VMResult previousResult : previous) {
            chunkStartTime = Math.min(previousResult.getDate(), chunkStartTime);
        }
        for (VMResult previousResult : current) {
            chunkStartTime = Math.min(previousResult.getDate(), chunkStartTime);
        }
        return chunkStartTime;
    }

    private void handleChunk(Map.Entry<String, EvaluationPair> entry, TestMethodCall testcase, VMResultChunk cleanedChunk) {
        MeasurementFileFinder finder = new MeasurementFileFinder(this.cleanFolder, testcase);
        File measurementFile = finder.getMeasurementFile();
        Kopemedata oneResultData = finder.getOneResultData();
        DatacollectorResult datacollector = finder.getDataCollector();
        if (this.checkChunk(cleanedChunk)) {
            datacollector.getChunks().add(cleanedChunk);
            JSONDataStorer.storeData((File)measurementFile, (Kopemedata)oneResultData);
            ++this.correct;
        } else {
            this.printFailureInfo(entry, cleanedChunk, measurementFile);
        }
    }

    private void printFailureInfo(Map.Entry<String, EvaluationPair> entry, VMResultChunk currentChunk, File measurementFile) {
        for (VMResult r : entry.getValue().getPrevius()) {
            LOG.debug("Value: {} Executions: {} Repetitions: {}", (Object)r.getValue(), (Object)r.getIterations(), (Object)r.getRepetitions());
        }
        for (VMResult r : entry.getValue().getCurrent()) {
            LOG.debug("Value:  {} Executions: {} Repetitions: {}", (Object)r.getValue(), (Object)r.getIterations(), (Object)r.getRepetitions());
        }
        LOG.debug("Too few correct measurements: {} ", (Object)measurementFile.getAbsolutePath());
        LOG.debug("Measurements: {} / {}", (Object)currentChunk.getResults().size(), (Object)(entry.getValue().getPrevius().size() + entry.getValue().getCurrent().size()));
    }

    public boolean checkChunk(VMResultChunk currentChunk) {
        return currentChunk.getResults().size() > 2;
    }

    private static final long ceilDiv(long x, long y) {
        return -Math.floorDiv(-x, y);
    }

    private List<VMResult> getChunk(String commit, long minExecutionCount, List<VMResult> previous) {
        List<VMResult> previousClean = StatisticUtil.shortenValues(previous);
        return previousClean.stream().filter(result -> {
            long expectedSize;
            boolean isCorrect;
            int resultSize = result.getFulldata().getValues().size();
            boolean bl = isCorrect = (long)resultSize == (expectedSize = Cleaner.ceilDiv(minExecutionCount, 2L)) && !Double.isNaN(result.getValue());
            if (!isCorrect) {
                LOG.debug("Wrong size: {} Expected: {}", (Object)resultSize, (Object)expectedSize);
            }
            return isCorrect;
        }).map(result -> this.cleanResult(commit, (VMResult)result)).collect(Collectors.toList());
    }

    private VMResult cleanResult(String commit, VMResult result) {
        result.setCommit(commit);
        result.setWarmup((long)result.getFulldata().getValues().size());
        result.setIterations((long)result.getFulldata().getValues().size());
        result.setRepetitions(result.getRepetitions());
        result.setMin(null);
        result.setMax(null);
        result.setFulldata(new Fulldata());
        return result;
    }
}

