/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dataloading;

import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.measurement.dataloading.DataReader;
import de.dagere.peass.measurement.statistics.data.TestData;
import java.io.File;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DataAnalyser {
    private static final Logger LOG = LogManager.getLogger(DataAnalyser.class);
    private boolean isFinished = false;
    protected final CommitComparatorInstance comparator;

    public DataAnalyser(CommitComparatorInstance comparator) {
        this.comparator = comparator;
    }

    public void analyseFolder(File measurementsFolder) throws InterruptedException {
        LOG.info("Loading: {}", (Object)measurementsFolder);
        if (!measurementsFolder.exists()) {
            LOG.error("Folder not existing: {}", (Object)measurementsFolder);
            System.exit(1);
        }
        final LinkedBlockingQueue<TestData> measurements = new LinkedBlockingQueue<TestData>();
        Thread readerThread = DataReader.startReadVersionDataMap(measurementsFolder, measurements, this.comparator);
        Thread processorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DataAnalyser.this.isFinished = false;
                try {
                    TestData measurementEntry = (TestData)measurements.take();
                    while (measurementEntry != DataReader.POISON_PILL && !DataAnalyser.this.isFinished) {
                        DataAnalyser.this.processTestdata(measurementEntry);
                        measurementEntry = (TestData)measurements.take();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        processorThread.start();
        readerThread.join();
        this.finishProcessingIfRunning(processorThread);
    }

    private void finishProcessingIfRunning(Thread processorThread) throws InterruptedException {
        Thread.sleep(100L);
        this.isFinished = true;
        processorThread.join();
    }

    public abstract void processTestdata(TestData var1);

    public void processDataFolder(File folder) {
        for (File measurementFolder : folder.listFiles()) {
            if (!measurementFolder.isDirectory() || measurementFolder.getName().equals("ignore") || measurementFolder.getName().equals("clean")) continue;
            if (measurementFolder.getName().equals("measurements")) {
                LOG.info("Analysing: {}", (Object)measurementFolder.getAbsolutePath());
                try {
                    this.analyseFolder(measurementFolder);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.processDataFolder(measurementFolder);
        }
    }
}

