/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dataloading;

import de.dagere.kopeme.datastorage.JSONDataLoader;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.measurement.statistics.data.TestData;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DataReader {
    private static final int MAX_QUEUE_SIZE = 25;
    private static final Logger LOG = LogManager.getLogger(DataReader.class);
    public static final TestData POISON_PILL = new TestData(null, null, null);
    private static int size = 0;

    private DataReader() {
    }

    public static Thread startReadVersionDataMap(final File fullDataFolder, final LinkedBlockingQueue<TestData> myQueue, final CommitComparatorInstance comparator) {
        Thread readerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                size = 0;
                LOG.debug("Starting data-reading from: {}", (Object)fullDataFolder);
                DataReader.readDataToQueue(fullDataFolder, myQueue, comparator);
                myQueue.add(POISON_PILL);
                LOG.debug("Finished data-reading, testcase-changes: {}", (Object)size);
            }
        });
        readerThread.start();
        return readerThread;
    }

    private static void readDataToQueue(File fullDataFolder, LinkedBlockingQueue<TestData> measurements, CommitComparatorInstance comparator) {
        LOG.info("Loading folder: {}", (Object)fullDataFolder);
        for (File clazzFile : fullDataFolder.listFiles()) {
            Map<String, TestData> currentMeasurement = DataReader.readClassFolder(clazzFile, comparator);
            for (TestData data : currentMeasurement.values()) {
                LOG.debug("Add: {}", (Object)(data.getTestClass() + " " + data.getTestMethod()));
                while (measurements.size() > 25) {
                    LOG.info("Waiting, Measurements: {} Max-Queue-Size: {}", (Object)measurements.size(), (Object)25);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                measurements.add(data);
                size += data.getVersions();
            }
        }
    }

    public static Map<String, TestData> readClassFolder(File clazzFile, CommitComparatorInstance comparator) {
        HashMap<String, TestData> currentMeasurement = new HashMap<String, TestData>();
        for (File commitOfPair : clazzFile.listFiles()) {
            if (commitOfPair.isDirectory()) {
                for (File commitCurrent : commitOfPair.listFiles()) {
                    for (File measurementFile : commitCurrent.listFiles((FileFilter)new WildcardFileFilter("*.json"))) {
                        DataReader.readMeasurementFile(currentMeasurement, commitOfPair, commitCurrent, measurementFile, comparator);
                    }
                    for (File measurementFile : commitCurrent.listFiles((FileFilter)new WildcardFileFilter("*.xml"))) {
                        DataReader.readMeasurementFile(currentMeasurement, commitOfPair, commitCurrent, measurementFile, comparator);
                    }
                }
                continue;
            }
            LOG.error("Version-folder does not exist: {}", (Object)commitOfPair.getAbsolutePath());
        }
        return currentMeasurement;
    }

    private static void readMeasurementFile(Map<String, TestData> currentMeasurement, File commitOfPair, File commitCurrent, File measurementFile, CommitComparatorInstance comparator) {
        File[] commitFiles;
        Kopemedata resultData = JSONDataLoader.loadData((File)measurementFile);
        String testclazz = resultData.getClazz();
        TestMethodCall testcase = new TestMethodCall(resultData);
        TestData testData = currentMeasurement.get(testcase.getMethodWithParams());
        if (testData == null) {
            File originFile = measurementFile.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
            testData = new TestData(testcase, originFile, comparator);
            currentMeasurement.put(testcase.getMethodWithParams(), testData);
        }
        String predecessor = null;
        for (File commitFile : commitFiles = commitOfPair.listFiles()) {
            if (commitFile.getName().equals(commitOfPair.getName())) continue;
            predecessor = commitFile.getName();
        }
        if (predecessor != null) {
            testData.addMeasurement(commitOfPair.getName(), commitCurrent.getName(), predecessor, resultData);
        } else {
            LOG.error("No predecessor data for {} {} {} {}", (Object)commitCurrent.getName(), predecessor, (Object)testclazz, (Object)testcase.getMethodWithParams());
        }
    }
}

