/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dataloading;

import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.kopeme.kopemedata.VMResultChunk;
import de.dagere.peass.dependency.persistence.SelectedTests;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class KoPeMeDataHelper {
    public static final String[] getCommits(VMResultChunk chunk) {
        String[] commits = new String[2];
        Iterator iterator = chunk.getResults().iterator();
        commits[0] = ((VMResult)iterator.next()).getCommit();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                VMResult r = (VMResult)iterator.next();
                if (r.getCommit().equals(commits[0])) continue;
                commits[1] = r.getCommit();
                break;
            }
        }
        return commits;
    }

    public static final String[] getCommits(VMResultChunk chunk, SelectedTests selectedTests) {
        String[] commits = KoPeMeDataHelper.getCommits(chunk);
        return KoPeMeDataHelper.filterCommits(selectedTests, commits);
    }

    private static String[] filterCommits(SelectedTests selectedTests, String[] commits) {
        int secondIndex;
        String[] commitNames = selectedTests.getCommitNames();
        List<String> commitOrderList = Arrays.asList(commitNames);
        int firstIndex = commitOrderList.indexOf(commits[0]);
        if (firstIndex > (secondIndex = commitOrderList.indexOf(commits[1]))) {
            String[] commitsInCorrectOrder = new String[]{commits[1], commits[0]};
            return commitsInCorrectOrder;
        }
        return commits;
    }

    public static List<String> getCommitList(VMResultChunk chunk) {
        LinkedList<String> commits = new LinkedList<String>();
        for (VMResult result : chunk.getResults()) {
            if (commits.contains(result.getCommit())) continue;
            commits.add(result.getCommit());
        }
        return commits;
    }
}

