/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dataloading;

import de.dagere.kopeme.datastorage.JSONDataLoader;
import de.dagere.kopeme.kopemedata.DatacollectorResult;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.kopeme.kopemedata.TestMethod;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import java.io.File;
import java.util.List;

public class MeasurementFileFinder {
    private final File measurementFile;
    private final Kopemedata oneResultData;
    private final DatacollectorResult datacollector;

    public MeasurementFileFinder(File folder, TestMethodCall testcase) {
        String clazz = testcase.getClazz();
        String methodWithParams = testcase.getMethodWithParams();
        String shortClazz = clazz.substring(clazz.lastIndexOf(46) + 1);
        File xmlCandidateFull = new File(folder, clazz + "_" + methodWithParams + ".xml");
        File xmlCandidateShort = new File(folder, shortClazz + "_" + methodWithParams + ".xml");
        if (xmlCandidateFull.exists()) {
            this.measurementFile = xmlCandidateFull;
            this.oneResultData = this.loadData(this.measurementFile);
        } else if (xmlCandidateShort.exists()) {
            Kopemedata oneResultData2 = this.loadData(xmlCandidateShort);
            String otherFullClazz = oneResultData2.getClazz();
            if (!otherFullClazz.equals(clazz)) {
                this.measurementFile = xmlCandidateFull;
                this.oneResultData = this.loadData(this.measurementFile);
            } else {
                this.measurementFile = xmlCandidateShort;
                this.oneResultData = oneResultData2;
            }
        } else {
            File jsonCandidateFull = new File(folder, clazz + "_" + methodWithParams + ".json");
            if (!jsonCandidateFull.exists()) {
                File jsonCandidateShort = new File(folder, shortClazz + "_" + methodWithParams + ".json");
                if (jsonCandidateShort.exists()) {
                    Kopemedata oneResultData2 = this.loadData(jsonCandidateShort);
                    String otherFullClazz = oneResultData2.getClazz();
                    if (!otherFullClazz.equals(clazz)) {
                        this.measurementFile = jsonCandidateShort;
                        this.oneResultData = this.loadData(this.measurementFile);
                    } else {
                        this.measurementFile = jsonCandidateShort;
                        this.oneResultData = oneResultData2;
                    }
                } else {
                    this.measurementFile = jsonCandidateShort;
                    this.oneResultData = new Kopemedata(clazz);
                }
            } else {
                this.measurementFile = jsonCandidateFull;
                this.oneResultData = this.loadData(this.measurementFile);
            }
        }
        this.oneResultData.setClazz(clazz);
        List testcaseList = this.oneResultData.getMethods();
        this.datacollector = MeasurementFileFinder.getDataCollector(testcase.getMethod(), testcaseList);
    }

    public Kopemedata loadData(File file) {
        Kopemedata oneResultData2 = JSONDataLoader.loadData((File)file);
        return oneResultData2;
    }

    public File getMeasurementFile() {
        return this.measurementFile;
    }

    public Kopemedata getOneResultData() {
        return this.oneResultData;
    }

    public DatacollectorResult getDataCollector() {
        return this.datacollector;
    }

    public static DatacollectorResult getDataCollector(String method, List<TestMethod> testcaseList) {
        DatacollectorResult datacollector = null;
        for (TestMethod testcase : testcaseList) {
            if (!testcase.getMethod().equals(method)) continue;
            datacollector = (DatacollectorResult)testcase.getDatacollectorResults().get(0);
        }
        if (datacollector == null) {
            TestMethod testcase = new TestMethod(method);
            testcaseList.add(testcase);
            datacollector = new DatacollectorResult("");
            testcase.getDatacollectorResults().add(datacollector);
        }
        return datacollector;
    }
}

