/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dataloading;

import de.dagere.kopeme.datacollection.tempfile.WrittenResultReaderBin;
import de.dagere.kopeme.datastorage.JSONDataLoader;
import de.dagere.kopeme.datastorage.JSONDataStorer;
import de.dagere.kopeme.kopemedata.DatacollectorResult;
import de.dagere.kopeme.kopemedata.Fulldata;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.kopeme.kopemedata.MeasuredValue;
import de.dagere.kopeme.kopemedata.TestMethod;
import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.kopeme.kopemedata.VMResultChunk;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.measurement.statistics.StatisticUtil;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.inference.TestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultipleVMTestUtil {
    private static final Logger LOG = LogManager.getLogger(MultipleVMTestUtil.class);

    public static void main(String[] args) {
        File resultFile = new File(args[0]);
        MultipleVMTestUtil.analyseOneRun(resultFile);
    }

    public static void analyseOneRun(File resultFile) {
        DescriptiveStatistics st = MultipleVMTestUtil.getStatistics(resultFile);
        LOG.info("Durchschnitt: " + st.getMean());
    }

    public static DescriptiveStatistics getStatistics(File resultFile) {
        Kopemedata fullResultData = JSONDataLoader.loadData((File)resultFile);
        DatacollectorResult oneRunDatacollector = fullResultData.getFirstTimeDataCollector();
        DescriptiveStatistics st = new DescriptiveStatistics();
        for (VMResult r : oneRunDatacollector.getResults()) {
            st.addValue(r.getValue());
        }
        return st;
    }

    public static void saveSummaryData(File summaryResultFile, File oneResultFile, VMResult oneResult, TestMethodCall testcase, String commit, long currentChunkStart, String datacollectorName) {
        LOG.info("Writing to merged result file: {}", (Object)summaryResultFile);
        Kopemedata summaryData = MultipleVMTestUtil.initKopemeData(summaryResultFile, testcase);
        VMResultChunk summaryChunk = MultipleVMTestUtil.findChunk(currentChunkStart, summaryData, datacollectorName);
        if (oneResult.getFulldata().getFileName() != null) {
            SummaryStatistics st = MultipleVMTestUtil.getExternalFileStatistics(oneResultFile, datacollectorName, oneResult);
            MultipleVMTestUtil.saveData(summaryResultFile, commit, summaryData, summaryChunk, oneResult, st);
        } else {
            VMResult cleaned = oneResult.getWarmup() != 0L ? StatisticUtil.shortenResult(oneResult) : oneResult;
            Fulldata realData = cleaned.getFulldata();
            if (realData != null && realData.getValues() != null && realData.getValues().size() > 0) {
                SummaryStatistics st = MultipleVMTestUtil.createStatistics(realData);
                MultipleVMTestUtil.saveData(summaryResultFile, commit, summaryData, summaryChunk, oneResult, st);
            } else {
                LOG.error("Fulldata of " + String.valueOf(oneResultFile) + " empty!");
            }
        }
    }

    private static void saveData(File summaryResultFile, String commit, Kopemedata summaryData, VMResultChunk summaryChunk, VMResult oneResult, SummaryStatistics st) {
        VMResult result = MultipleVMTestUtil.createResultFromStatistic(commit, st, oneResult.getRepetitions());
        result.setDate(oneResult.getDate());
        result.setWarmup(oneResult.getWarmup());
        result.setParameters(oneResult.getParameters());
        summaryChunk.getResults().add(result);
        JSONDataStorer.storeData((File)summaryResultFile, (Kopemedata)summaryData);
    }

    private static SummaryStatistics getExternalFileStatistics(File oneResultFile, String dataCollectorName, VMResult oneResult) {
        File resultFile = new File(oneResultFile.getParentFile(), oneResult.getFulldata().getFileName());
        WrittenResultReaderBin reader = new WrittenResultReaderBin(resultFile);
        HashSet<String> keys = new HashSet<String>();
        keys.add(dataCollectorName);
        reader.read(null, keys);
        SummaryStatistics st = reader.getCollectorSummary(dataCollectorName);
        return st;
    }

    public static Kopemedata initKopemeData(File summaryResultFile, TestMethodCall testcase) {
        Kopemedata fullResultData = JSONDataLoader.loadData((File)summaryResultFile);
        if (fullResultData.getMethods().size() == 0) {
            fullResultData.setClazz(testcase.getClassWithModule());
            fullResultData.getMethods().add(new TestMethod(testcase.getMethod()));
        }
        return fullResultData;
    }

    public static VMResultChunk findChunk(long currentChunkStart, Kopemedata fullResultData, String datacollectorName) {
        DatacollectorResult fullFileDatacollector;
        VMResultChunk realChunk;
        List fullResultFileDatacollectorList = fullResultData.getFirstMethodResult().getDatacollectorResults();
        if (fullResultFileDatacollectorList.size() == 0) {
            fullResultFileDatacollectorList.add(new DatacollectorResult(datacollectorName));
        }
        if ((realChunk = MultipleVMTestUtil.findChunk(currentChunkStart, fullFileDatacollector = (DatacollectorResult)fullResultFileDatacollectorList.get(0))) == null) {
            realChunk = new VMResultChunk();
            realChunk.setChunkStartTime(currentChunkStart);
            fullFileDatacollector.getChunks().add(realChunk);
        }
        return realChunk;
    }

    public static VMResultChunk findChunk(long currentChunkStart, DatacollectorResult fullFileDatacollector) {
        VMResultChunk realChunk = null;
        for (VMResultChunk chunk : fullFileDatacollector.getChunks()) {
            if (chunk.getChunkStartTime() != currentChunkStart) continue;
            realChunk = chunk;
            break;
        }
        return realChunk;
    }

    public static DescriptiveStatistics getChunkData(VMResultChunk chunk, String commit) {
        DescriptiveStatistics desc1 = new DescriptiveStatistics();
        for (VMResult result : chunk.getResults()) {
            if (!result.getCommit().equals(commit) || Double.isNaN(result.getValue())) continue;
            desc1.addValue(result.getValue());
        }
        return desc1;
    }

    public static long getMinRepetitionCount(List<VMResult> results) {
        long minRepetitions = Long.MAX_VALUE;
        long minMultiplied = Long.MAX_VALUE;
        for (VMResult result : results) {
            long currentRepetitions;
            long currentIterations = result.getIterations();
            long multiplied = currentIterations * (currentRepetitions = result.getRepetitions());
            if (multiplied == 0L || multiplied >= minMultiplied) continue;
            minRepetitions = currentRepetitions;
            minMultiplied = multiplied;
        }
        return minRepetitions;
    }

    public static long getMinIterationCount(List<VMResult> results) {
        long minIterations = Long.MAX_VALUE;
        long minMultiplied = Long.MAX_VALUE;
        for (VMResult result : results) {
            long currentRepetitions;
            long currentIterations = result.getIterations();
            long multiplied = currentIterations * (currentRepetitions = result.getRepetitions());
            if (multiplied == 0L || multiplied >= minMultiplied) continue;
            minIterations = currentIterations;
            minMultiplied = multiplied;
        }
        return minIterations;
    }

    private static VMResult createResultFromStatistic(String commit, SummaryStatistics st, long repetitions) {
        VMResult result = new VMResult();
        result.setValue(st.getMean());
        result.setMin(Double.valueOf(st.getMin()));
        result.setMax(Double.valueOf(st.getMax()));
        result.setCommit(commit);
        result.setDeviation(st.getStandardDeviation());
        result.setIterations(st.getN());
        result.setRepetitions(repetitions);
        return result;
    }

    private static SummaryStatistics createStatistics(Fulldata realData) {
        SummaryStatistics st2 = new SummaryStatistics();
        double[] values = new double[realData.getValues().size()];
        int i = 0;
        for (MeasuredValue value : realData.getValues()) {
            long parseDouble = value.getValue();
            st2.addValue((double)parseDouble);
            values[i++] = parseDouble;
        }
        return st2;
    }

    public static List<Double> getAverages(List<VMResult> values) {
        return values.stream().mapToDouble(vmVal -> vmVal.getFulldata().getValues().stream().mapToDouble(val -> val.getValue()).sum() / (double)vmVal.getFulldata().getValues().size()).boxed().sorted().collect(Collectors.toList());
    }

    public static double[] getAveragesArray(List<VMResult> values) {
        List<Double> list = MultipleVMTestUtil.getAverages(values);
        double[] array = ArrayUtils.toPrimitive((Double[])list.toArray(new Double[0]));
        return array;
    }

    public static SummaryStatistics getStatistic(List<VMResult> results) {
        SummaryStatistics statistisc = new SummaryStatistics();
        results.forEach(result -> statistisc.addValue(result.getValue()));
        return statistisc;
    }

    public static int compareDouble(List<Double> predecessor, List<Double> current) {
        boolean change = TestUtils.tTest((double[])ArrayUtils.toPrimitive((Double[])predecessor.toArray(new Double[0])), (double[])ArrayUtils.toPrimitive((Double[])current.toArray(new Double[0])), (double)0.05);
        SummaryStatistics statisticPredecessor = new SummaryStatistics();
        predecessor.forEach(result -> statisticPredecessor.addValue(result.doubleValue()));
        SummaryStatistics statisticCurrent = new SummaryStatistics();
        current.forEach(result -> statisticCurrent.addValue(result.doubleValue()));
        if (change) {
            if (statisticPredecessor.getMean() < statisticCurrent.getMean()) {
                return -1;
            }
            return 1;
        }
        return 0;
    }
}

