/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dataloading;

import de.dagere.kopeme.datastorage.JSONDataLoader;
import de.dagere.kopeme.kopemedata.DatacollectorResult;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.kopeme.kopemedata.TestMethod;
import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.kopeme.kopemedata.VMResultChunk;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.dataloading.MultipleVMTestUtil;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultLoader {
    private static final Logger LOG = LogManager.getLogger(ResultLoader.class);
    private final MeasurementConfig config;
    private final List<Double> predecessor = new LinkedList<Double>();
    private final List<Double> current = new LinkedList<Double>();

    public ResultLoader(MeasurementConfig config) {
        this.config = config;
    }

    public void loadData(PeassFolders folders, TestMethodCall testcase, long currentChunkStart) {
        File kopemeFile = folders.getSummaryFile(testcase);
        Kopemedata data = JSONDataLoader.loadData((File)kopemeFile);
        if (data.getMethods().size() > 0) {
            DatacollectorResult dataCollector = (DatacollectorResult)((TestMethod)data.getMethods().get(0)).getDatacollectorResults().get(0);
            VMResultChunk realChunk = MultipleVMTestUtil.findChunk(currentChunkStart, dataCollector);
            this.loadChunk(realChunk);
        }
    }

    public void loadChunk(VMResultChunk realChunk) {
        LOG.debug("Chunk size: {}", (Object)realChunk.getResults().size());
        for (VMResult result : realChunk.getResults()) {
            if (result.getIterations() + result.getWarmup() != (long)this.config.getAllIterations() || result.getRepetitions() != (long)this.config.getRepetitions()) continue;
            if (result.getCommit().equals(this.config.getFixedCommitConfig().getCommitOld())) {
                this.predecessor.add(result.getValue());
            }
            if (!result.getCommit().equals(this.config.getFixedCommitConfig().getCommit())) continue;
            this.current.add(result.getValue());
        }
    }

    public DescriptiveStatistics getStatisticsPredecessor() {
        return new DescriptiveStatistics(this.getValsPredecessor());
    }

    public DescriptiveStatistics getStatisticsCurrent() {
        return new DescriptiveStatistics(this.getValsCurrent());
    }

    public double[] getValsPredecessor() {
        return ArrayUtils.toPrimitive((Double[])this.predecessor.toArray(new Double[0]));
    }

    public double[] getValsCurrent() {
        return ArrayUtils.toPrimitive((Double[])this.current.toArray(new Double[0]));
    }

    public static List<VMResult> removeResultsWithWrongConfiguration(List<VMResult> results) {
        LinkedList<VMResult> cleaned = new LinkedList<VMResult>();
        long repetitions = MultipleVMTestUtil.getMinRepetitionCount(results);
        long iterations = MultipleVMTestUtil.getMinIterationCount(results);
        for (VMResult result : results) {
            if (repetitions != result.getRepetitions() || iterations != result.getIterations()) continue;
            cleaned.add(result);
        }
        return cleaned;
    }
}

