/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dependencyprocessors;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.vcs.GitUtils;
import de.dagere.peass.vcs.VersionControlSystem;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractMeasurementProcessRunner {
    private static final Logger LOG = LogManager.getLogger(AbstractMeasurementProcessRunner.class);
    protected final VersionControlSystem vcs;
    protected final PeassFolders folders;

    public AbstractMeasurementProcessRunner(PeassFolders folders) {
        this.folders = folders;
        this.vcs = folders.getVCS();
    }

    public abstract void runOnce(TestMethodCall var1, String var2, int var3, File var4);

    protected void initCommit(String commit) {
        if (this.vcs.equals((Object)VersionControlSystem.SVN)) {
            throw new RuntimeException("SVN not supported currently.");
        }
        GitUtils.goToCommit((String)commit, (File)this.folders.getProjectFolder());
    }

    protected File initVMFolder(String commit, int vmid, File logFolder) {
        File vmidFolder = new File(logFolder, "vm_" + vmid + "_" + commit);
        vmidFolder.mkdirs();
        LOG.info("Initial checkout finished, VM-Folder " + vmidFolder.getAbsolutePath() + " exists: " + vmidFolder.exists());
        return vmidFolder;
    }

    void cleanup() {
        this.emptyFolder(this.folders.getTempDir());
        this.emptyFolder(this.folders.getKiekerTempFolder());
        System.gc();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void emptyFolder(File tempDir) {
        for (File createdTempFile : tempDir.listFiles()) {
            try {
                if (createdTempFile.isDirectory()) {
                    FileUtils.deleteDirectory((File)createdTempFile);
                    continue;
                }
                createdTempFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

