/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dependencyprocessors;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.dataloading.ResultLoader;
import de.dagere.peass.measurement.dependencyprocessors.DependencyTester;
import de.dagere.peass.measurement.dependencyprocessors.helper.EarlyBreakDecider;
import de.dagere.peass.measurement.dependencyprocessors.helper.ProgressWriter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdaptiveTester
extends DependencyTester {
    private static final Logger LOG = LogManager.getLogger(AdaptiveTester.class);
    private int finishedVMs = 0;

    public AdaptiveTester(PeassFolders folders, MeasurementConfig measurementConfig, EnvironmentVariables env, CommitComparatorInstance comparator) {
        super(folders, measurementConfig, env, comparator);
    }

    @Override
    public void evaluate(TestMethodCall testcase) throws IOException {
        this.initEvaluation(testcase);
        File logFolder = this.folders.getMeasureLogFolder(this.configuration.getFixedCommitConfig().getCommit(), testcase);
        try (ProgressWriter writer = new ProgressWriter(this.folders.getProgressFile(), this.configuration.getVms());){
            this.evaluateWithAdaption(testcase, logFolder, writer);
        }
    }

    protected void evaluateWithAdaption(TestMethodCall testcase, File logFolder, ProgressWriter writer) throws IOException {
        this.currentChunkStart = System.currentTimeMillis();
        this.finishedVMs = 0;
        while (this.finishedVMs < this.configuration.getVms()) {
            long comparisonStart = System.currentTimeMillis();
            this.runOneComparison(logFolder, testcase, this.finishedVMs);
            boolean savelyDecidable = this.checkIsDecidable(testcase, this.finishedVMs);
            if (savelyDecidable) {
                LOG.debug("Savely decidable - finishing testing");
                break;
            }
            boolean shouldBreak = this.reductionManager.updateExecutions(testcase, this.finishedVMs, this.getCurrentOrganizer());
            if (shouldBreak) {
                LOG.debug("Too few executions possible - finishing testing.");
                break;
            }
            long durationInSeconds = (System.currentTimeMillis() - comparisonStart) / 1000L;
            writer.write(durationInSeconds, this.finishedVMs);
            this.betweenVMCooldown();
            ++this.finishedVMs;
        }
    }

    public int getFinishedVMs() {
        return this.finishedVMs;
    }

    @Override
    public boolean checkIsDecidable(TestMethodCall testcase, int vmid) {
        boolean savelyDecidable;
        if (this.configuration.isEarlyStop()) {
            ResultLoader loader = new ResultLoader(this.configuration);
            loader.loadData(this.folders, testcase, this.currentChunkStart);
            LOG.debug((Object)loader.getStatisticsCurrent());
            DescriptiveStatistics statisticsPredecessor = loader.getStatisticsPredecessor();
            DescriptiveStatistics statisticsCurrent = loader.getStatisticsCurrent();
            EarlyBreakDecider decider = new EarlyBreakDecider(this.configuration, (StatisticalSummary)statisticsCurrent, (StatisticalSummary)statisticsPredecessor);
            savelyDecidable = decider.isBreakPossible(vmid);
        } else {
            savelyDecidable = false;
        }
        return savelyDecidable;
    }
}

