/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dependencyprocessors;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.FixedCommitConfig;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.config.MeasurementStrategy;
import de.dagere.peass.dependency.ExecutorCreator;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.execution.processutils.ProcessBuilderHelper;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.cleaning.Cleaner;
import de.dagere.peass.measurement.dataloading.DataReader;
import de.dagere.peass.measurement.dependencyprocessors.KiekerResultHandler;
import de.dagere.peass.measurement.dependencyprocessors.OnceRunner;
import de.dagere.peass.measurement.dependencyprocessors.ParallelExecutionRunnable;
import de.dagere.peass.measurement.dependencyprocessors.helper.ProgressWriter;
import de.dagere.peass.measurement.dependencyprocessors.reductioninfos.ReductionManager;
import de.dagere.peass.measurement.organize.FolderDeterminer;
import de.dagere.peass.measurement.organize.ResultOrganizer;
import de.dagere.peass.measurement.organize.ResultOrganizerParallel;
import de.dagere.peass.measurement.statistics.data.TestData;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DependencyTester
implements KiekerResultHandler {
    private static final Logger LOG = LogManager.getLogger(DependencyTester.class);
    protected final PeassFolders folders;
    protected final MeasurementConfig configuration;
    protected final EnvironmentVariables env;
    private ResultOrganizer currentOrganizer;
    protected long currentChunkStart = 0L;
    private final CommitComparatorInstance comparator;
    protected final ReductionManager reductionManager;

    public DependencyTester(PeassFolders folders, MeasurementConfig measurementConfig, EnvironmentVariables env, CommitComparatorInstance comparator) {
        this.folders = folders;
        this.configuration = measurementConfig;
        this.env = env;
        this.comparator = comparator;
        this.reductionManager = new ReductionManager(measurementConfig);
    }

    public void evaluate(TestMethodCall testcase) throws IOException, InterruptedException, XmlPullParserException {
        this.initEvaluation(testcase);
        File logFolder = this.folders.getMeasureLogFolder(this.configuration.getFixedCommitConfig().getCommit(), testcase);
        try (ProgressWriter writer = new ProgressWriter(this.folders.getProgressFile(), this.configuration.getVms());){
            this.evaluateSimple(testcase, logFolder, writer);
        }
    }

    protected void initEvaluation(TestMethodCall testcase) {
        FixedCommitConfig fixedCommitConfig = this.configuration.getFixedCommitConfig();
        LOG.info("Executing test " + testcase.getClazz() + " " + testcase.getMethod() + " in commits {} and {}", (Object)fixedCommitConfig.getCommitOld(), (Object)fixedCommitConfig.getCommit());
        new FolderDeterminer(this.folders).testResultFolders(fixedCommitConfig.getCommit(), fixedCommitConfig.getCommitOld(), testcase);
    }

    private void evaluateSimple(TestMethodCall testcase, File logFolder, ProgressWriter writer) throws IOException {
        this.currentChunkStart = System.currentTimeMillis();
        for (int finishedVMs = 0; finishedVMs < this.configuration.getVms(); ++finishedVMs) {
            long comparisonStart = System.currentTimeMillis();
            this.runOneComparison(logFolder, testcase, finishedVMs);
            boolean shouldBreak = this.reductionManager.updateExecutions(testcase, finishedVMs, this.getCurrentOrganizer());
            if (shouldBreak) {
                LOG.debug("Too few executions possible - finishing testing.");
                break;
            }
            long durationInSeconds = (System.currentTimeMillis() - comparisonStart) / 1000L;
            writer.write(durationInSeconds, finishedVMs);
            this.betweenVMCooldown();
        }
    }

    protected void betweenVMCooldown() {
        if (this.configuration.isCallSyncBetweenVMs()) {
            ProcessBuilderHelper.syncToHdd();
        }
        try {
            Thread.sleep(this.configuration.getWaitTimeBetweenVMs());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void postEvaluate() {
        if (this.currentOrganizer != null) {
            File cleanFolder = this.folders.getNativeCleanFolder();
            if (!cleanFolder.exists()) {
                cleanFolder.mkdirs();
            }
            Cleaner cleaner = new Cleaner(cleanFolder, this.comparator);
            for (File clazzFile : this.folders.getDetailResultFolder().listFiles()) {
                Map<String, TestData> testdata = DataReader.readClassFolder(clazzFile, this.comparator);
                for (Map.Entry<String, TestData> entry : testdata.entrySet()) {
                    cleaner.processTestdata(entry.getValue());
                }
            }
        }
    }

    public void runOneComparison(File logFolder, TestMethodCall testcase, int vmid) throws IOException {
        String[] commits = this.getVersions();
        if (this.configuration.getMeasurementStrategy().equals((Object)MeasurementStrategy.SEQUENTIAL)) {
            LOG.info("Running sequential");
            this.runSequential(logFolder, testcase, vmid, commits);
        } else if (this.configuration.getMeasurementStrategy().equals((Object)MeasurementStrategy.PARALLEL)) {
            LOG.info("Running parallel");
            this.runParallel(logFolder, testcase, vmid, commits);
        }
    }

    private String[] getVersions() {
        String[] commits = new String[]{this.configuration.getFixedCommitConfig().getCommitOld().equals("HEAD~1") ? this.configuration.getFixedCommitConfig().getCommit() + "~1" : this.configuration.getFixedCommitConfig().getCommitOld(), this.configuration.getFixedCommitConfig().getCommit()};
        return commits;
    }

    private void runParallel(File logFolder, TestMethodCall testcase, int vmid, String[] commits) throws IOException {
        ResultOrganizerParallel organizer = new ResultOrganizerParallel(this.folders, this.configuration.getFixedCommitConfig().getCommit(), this.currentChunkStart, this.configuration.getKiekerConfig().isUseKieker(), this.configuration.isSaveAll(), testcase, this.configuration.getAllIterations());
        this.currentOrganizer = organizer;
        ParallelExecutionRunnable[] runnables = new ParallelExecutionRunnable[2];
        for (int i = 0; i < 2; ++i) {
            String commit = commits[i];
            runnables[i] = new ParallelExecutionRunnable(organizer, commit, testcase, vmid, logFolder, this, this.configuration.getExecutionConfig().getGitCryptKey());
        }
        this.runParallel(runnables);
    }

    public void runParallel(ParallelExecutionRunnable[] runnables) {
        int i;
        Thread[] threads = new Thread[2];
        for (i = 0; i < 2; ++i) {
            threads[i] = new Thread(runnables[i]);
            threads[i].start();
        }
        try {
            for (i = 0; i < 2; ++i) {
                threads[i].join();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void runSequential(File logFolder, TestMethodCall testcase, int vmid, String[] commits) throws IOException {
        this.currentOrganizer = new ResultOrganizer(this.folders, this.configuration.getFixedCommitConfig().getCommit(), this.currentChunkStart, this.configuration.getKiekerConfig().isUseKieker(), this.configuration.isSaveAll(), testcase, this.configuration.getAllIterations());
        for (String commit : commits) {
            this.runOnce(testcase, commit, vmid, logFolder);
        }
    }

    private void runOnce(TestMethodCall testcase, String commit, int vmid, File logFolder) {
        TestExecutor testExecutor = this.getExecutor(this.folders, commit);
        OnceRunner runner = new OnceRunner(this.folders, testExecutor, this.getCurrentOrganizer(), this);
        runner.runOnce(testcase, commit, vmid, logFolder);
    }

    protected synchronized TestExecutor getExecutor(PeassFolders currentFolders, String commit) {
        TestTransformer transformer = ExecutorCreator.createTestTransformer((PeassFolders)currentFolders, (ExecutionConfig)this.configuration.getExecutionConfig(), (MeasurementConfig)this.configuration);
        TestExecutor testExecutor = ExecutorCreator.createExecutor((PeassFolders)currentFolders, (TestTransformer)transformer, (EnvironmentVariables)this.env);
        return testExecutor;
    }

    @Override
    public void handleKiekerResults(String commit, File folder) {
    }

    public void setCommits(String commit, String commitOld) {
        this.configuration.getFixedCommitConfig().setCommit(commit);
        this.configuration.getFixedCommitConfig().setCommitOld(commitOld);
    }

    protected boolean checkIsDecidable(TestMethodCall testcase, int vmid) {
        return false;
    }

    public ResultOrganizer getCurrentOrganizer() {
        return this.currentOrganizer;
    }

    public PeassFolders getFolders() {
        return this.folders;
    }

    public ReductionManager getReductionManager() {
        return this.reductionManager;
    }
}

