/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dependencyprocessors;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.dependencyprocessors.AbstractMeasurementProcessRunner;
import de.dagere.peass.measurement.dependencyprocessors.DirectKiekerMeasurementTransformer;
import de.dagere.peass.measurement.dependencyprocessors.KiekerResultHandler;
import de.dagere.peass.measurement.organize.ResultOrganizer;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OnceRunner
extends AbstractMeasurementProcessRunner {
    private static final Logger LOG = LogManager.getLogger(OnceRunner.class);
    protected final TestTransformer testTransformer;
    protected final TestExecutor testExecutor;
    protected final ResultOrganizer currentOrganizer;
    private final KiekerResultHandler resultHandler;

    public OnceRunner(PeassFolders folders, TestExecutor testExecutor, ResultOrganizer currentOrganizer, KiekerResultHandler resultHandler) {
        super(folders);
        this.testTransformer = testExecutor.getTestTransformer();
        this.testExecutor = testExecutor;
        this.currentOrganizer = currentOrganizer;
        this.resultHandler = resultHandler;
        try {
            FileUtils.cleanDirectory((File)folders.getTempDir());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void runOnce(TestMethodCall testcase, String commit, int vmid, File logFolder) {
        this.initCommit(commit);
        File vmidFolder = this.initVMFolder(commit, vmid, logFolder);
        if (this.testTransformer.getConfig().getKiekerConfig().isUseKieker()) {
            this.testExecutor.loadClasses();
        }
        this.testExecutor.prepareKoPeMeExecution(new File(logFolder, "clean.txt"));
        long outerTimeout = 10 + (int)((double)this.testTransformer.getConfig().getTimeoutInSeconds() * 1.2);
        this.testExecutor.executeTest(testcase, vmidFolder, outerTimeout);
        if (this.testTransformer.getConfig().isDirectlyMeasureKieker()) {
            DirectKiekerMeasurementTransformer measurementTransformer = new DirectKiekerMeasurementTransformer(this.folders);
            measurementTransformer.transform(testcase);
        }
        LOG.debug("Handling Kieker results");
        this.resultHandler.handleKiekerResults(commit, this.currentOrganizer.getTempResultsFolder(commit));
        if (!this.testTransformer.getConfig().getKiekerConfig().isDisableKiekerKoPeMe()) {
            LOG.info("Organizing result paths");
            this.currentOrganizer.saveResultFiles(commit, vmid);
        } else {
            LOG.info("Not organizing result paths since the export should go to ExplorViz");
        }
        this.cleanup();
    }

    public ResultOrganizer getCurrentOrganizer() {
        return this.currentOrganizer;
    }
}

