/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dependencyprocessors;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.dependencyprocessors.DependencyTester;
import de.dagere.peass.measurement.dependencyprocessors.OnceRunner;
import de.dagere.peass.measurement.organize.ResultOrganizerParallel;
import java.io.File;
import java.io.IOException;

public class ParallelExecutionRunnable
implements Runnable {
    private ResultOrganizerParallel organizer;
    private final String commit;
    private final TestMethodCall testcase;
    private final int vmid;
    private final File logFolder;
    private final DependencyTester tester;
    private final PeassFolders temporaryFolders;

    public ParallelExecutionRunnable(ResultOrganizerParallel organizer, String commit, TestMethodCall testcase, int vmid, File logFolder, DependencyTester tester, String gitCryptKey) throws IOException {
        this.organizer = organizer;
        this.commit = commit;
        this.testcase = testcase;
        this.vmid = vmid;
        this.logFolder = logFolder;
        this.tester = tester;
        this.temporaryFolders = this.cloneProjectFolder(gitCryptKey);
    }

    @Override
    public void run() {
        TestExecutor testExecutor = this.tester.getExecutor(this.temporaryFolders, this.commit);
        OnceRunner runner = new OnceRunner(this.temporaryFolders, testExecutor, this.organizer, this.tester);
        runner.runOnce(this.testcase, this.commit, this.vmid, this.logFolder);
    }

    private PeassFolders cloneProjectFolder(String gitCryptKey) throws IOException {
        PeassFolders temporaryFolders = this.tester.getFolders().getTempFolder("parallel_" + this.commit, gitCryptKey);
        this.organizer.addCommitFolders(this.commit, temporaryFolders);
        return temporaryFolders;
    }
}

