/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dependencyprocessors.helper;

import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.measurement.statistics.Relation;
import de.dagere.peass.measurement.statistics.StatisticUtil;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EarlyBreakDecider {
    private static final Logger LOG = LogManager.getLogger(EarlyBreakDecider.class);
    private final StatisticalSummary statisticsPredecessor;
    private final StatisticalSummary statisticsCurrent;
    private final double type1error;
    private final double type2error;

    public EarlyBreakDecider(MeasurementConfig config, StatisticalSummary statisticsPredecessor, StatisticalSummary statisticsCurrent) {
        this.type1error = config.getStatisticsConfig().getType1error();
        this.type2error = config.getStatisticsConfig().getType2error();
        this.statisticsPredecessor = statisticsPredecessor;
        this.statisticsCurrent = statisticsCurrent;
    }

    public boolean isBreakPossible(int vmid) {
        boolean savelyDecidable = false;
        if (vmid > 3) {
            LOG.debug("T: {} {}", (Object)this.statisticsPredecessor.getN(), (Object)this.statisticsCurrent.getN());
            if (this.statisticsPredecessor.getN() > 3L && this.statisticsCurrent.getN() > 3L) {
                savelyDecidable = this.isSavelyDecidableBothHypothesis(vmid);
            } else if (vmid > 10) {
                LOG.debug("More than 10 executions and only {} / {} measurements - aborting", (Object)this.statisticsPredecessor.getN(), (Object)this.statisticsCurrent.getN());
                return true;
            }
        }
        return savelyDecidable;
    }

    public boolean isSavelyDecidableBothHypothesis(int vmid) {
        Relation relation;
        boolean savelyDecidable = false;
        if (this.statisticsPredecessor.getN() > 30L && this.statisticsCurrent.getN() > 30L && ((relation = StatisticUtil.agnosticTTest(this.statisticsPredecessor, this.statisticsCurrent, this.type1error, this.type2error)) == Relation.EQUAL || Relation.isUnequal(relation))) {
            LOG.info("Can savely decide: {}", (Object)relation);
            savelyDecidable = true;
        }
        return savelyDecidable;
    }
}

