/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dependencyprocessors.helper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class ProgressWriter
implements AutoCloseable {
    private final PrintWriter progressFileWriter;
    private final SummaryStatistics durationStatistics = new SummaryStatistics();
    private final int vms;

    public ProgressWriter(File resultFile, int vms) {
        try {
            this.progressFileWriter = new PrintWriter(resultFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.vms = vms;
    }

    public void write(long durationInSeconds, int finishedVMs) {
        this.durationStatistics.addValue((double)durationInSeconds);
        int duration = (int)((double)(this.vms - finishedVMs) * this.durationStatistics.getMean() / 60.0);
        int minutes = duration % 60;
        int hours = duration / 60;
        this.progressFileWriter.write("Finished " + finishedVMs + " Duration: " + durationInSeconds + " Avg: " + this.durationStatistics.getMean() + " Remaining: " + hours + "h " + minutes + "\n");
        this.progressFileWriter.flush();
    }

    @Override
    public void close() {
        this.progressFileWriter.close();
    }
}

