/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.dependencyprocessors.reductioninfos;

import de.dagere.kopeme.datastorage.JSONDataLoader;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.measurement.dependencyprocessors.reductioninfos.ReductionInformation;
import de.dagere.peass.measurement.dependencyprocessors.reductioninfos.ReductionReasons;
import de.dagere.peass.measurement.dependencyprocessors.reductioninfos.VMReductionInfo;
import de.dagere.peass.measurement.organize.ResultOrganizer;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReductionManager {
    private static final Logger LOG = LogManager.getLogger(ReductionManager.class);
    private final MeasurementConfig measurementConfig;
    private final ReductionInformation reductionInformation = new ReductionInformation();

    public ReductionManager(MeasurementConfig configuration) {
        this.measurementConfig = configuration;
    }

    public boolean updateExecutions(TestMethodCall testcase, int vmid, ResultOrganizer organizer) {
        boolean shouldBreak = false;
        VMResult commitOldResult = this.getLastResult(this.measurementConfig.getFixedCommitConfig().getCommitOld(), testcase, vmid, organizer);
        VMResult commitCurrentResult = this.getLastResult(this.measurementConfig.getFixedCommitConfig().getCommit(), testcase, vmid, organizer);
        if (vmid < 40) {
            VMReductionInfo reductionOld = this.shouldReduce(this.measurementConfig.getFixedCommitConfig().getCommitOld(), commitOldResult);
            VMReductionInfo reductionCurrent = this.shouldReduce(this.measurementConfig.getFixedCommitConfig().getCommit(), commitCurrentResult);
            int reducedIterations = Math.min(reductionOld.getReductionToIterationCount(), reductionCurrent.getReductionToIterationCount());
            if (reducedIterations != this.measurementConfig.getIterations()) {
                this.reductionInformation.addReduction(vmid, reductionOld, reductionCurrent);
                LOG.error("Should originally run {} iterations, but did not succeed (because of {}) - reducing to {}", (Object)this.measurementConfig.getIterations(), (Object)(String.valueOf((Object)reductionOld.getReason()) + " - " + String.valueOf((Object)reductionCurrent.getReason())), (Object)reducedIterations);
                shouldBreak = this.reduceExecutions(shouldBreak, reducedIterations);
                try {
                    File reductionFile = organizer.getFolders().getReductionFile(testcase);
                    Constants.OBJECTMAPPER.writeValue(reductionFile, (Object)this.reductionInformation);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return shouldBreak;
    }

    private VMReductionInfo shouldReduce(String commit, VMResult result) {
        VMReductionInfo reductionInfo;
        if (result == null) {
            reductionInfo = new VMReductionInfo(this.measurementConfig.getIterations() / 2, ReductionReasons.NO_RESULT_FILE);
            LOG.error("Measurement for {} is null", (Object)commit);
        } else if (result.getIterations() < (long)this.measurementConfig.getIterations()) {
            LOG.error("Measurement executions: {}", (Object)result.getIterations());
            int minOfExecuted = (int)result.getIterations() - 2;
            reductionInfo = new VMReductionInfo(minOfExecuted, ReductionReasons.TOO_FEW_ITERATIONS);
        } else if (Double.isNaN(result.getValue())) {
            LOG.error("Measurement executions: {}", (Object)result.getIterations());
            reductionInfo = new VMReductionInfo(this.measurementConfig.getIterations() / 2, ReductionReasons.NO_DATA);
        } else {
            reductionInfo = new VMReductionInfo(this.measurementConfig.getIterations());
        }
        return reductionInfo;
    }

    public boolean reduceExecutions(boolean shouldBreak, int lessIterations) {
        if (lessIterations > 3) {
            LOG.info("Reducing iterations too: {}", (Object)lessIterations);
            this.measurementConfig.setIterations(lessIterations);
            this.measurementConfig.setWarmup(0);
        } else if (this.measurementConfig.getRepetitions() > 5) {
            int reducedRepetitions = this.measurementConfig.getRepetitions() / 5;
            LOG.debug("Reducing repetitions to " + reducedRepetitions);
            this.measurementConfig.setRepetitions(reducedRepetitions);
        } else {
            LOG.error("Cannot reduce iterations ({}) or repetitions ({}) anymore", (Object)this.measurementConfig.getIterations(), (Object)this.measurementConfig.getRepetitions());
            shouldBreak = true;
        }
        return shouldBreak;
    }

    public VMResult getLastResult(String version, TestMethodCall testcase, int vmid, ResultOrganizer organizer) {
        System.out.println("Getting " + version + " " + String.valueOf(testcase) + " " + vmid);
        File resultFile = organizer.getResultFile(testcase, vmid, version);
        if (resultFile.exists()) {
            Kopemedata data = JSONDataLoader.loadData((File)resultFile);
            VMResult lastResult = data.getFirstResult();
            return lastResult;
        }
        LOG.debug("Resultfile {} does not exist", (Object)resultFile);
        return null;
    }
}

