/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.organize;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KiekerFileCompressor {
    private static final Logger LOG = LogManager.getLogger(KiekerFileCompressor.class);
    private int thresholdForZippingInMB = 5;
    private int thresholdForDeletingInMB = 1000;

    public void moveOrCompressFile(File destFolder, File kiekerFolder) throws IOException {
        long size = FileUtils.sizeOf((File)kiekerFolder);
        long sizeInMb = size / 0x100000L;
        LOG.debug("Kieker folder size: {} MB ({})", (Object)sizeInMb, (Object)size);
        if (sizeInMb > (long)this.thresholdForDeletingInMB) {
            LOG.info("Result folder {} too big ({} MB) for saving; deleting completely", (Object)destFolder, (Object)sizeInMb);
            FileUtils.deleteDirectory((File)kiekerFolder);
        } else if (sizeInMb > (long)this.thresholdForZippingInMB) {
            this.compressKiekerFolder(destFolder, kiekerFolder);
            FileUtils.deleteDirectory((File)kiekerFolder);
        } else {
            File dest = new File(destFolder, kiekerFolder.getName());
            FileUtils.moveDirectory((File)kiekerFolder, (File)dest);
        }
    }

    private void compressKiekerFolder(File destFolder, File kiekerFolder) throws IOException {
        File dest = new File(destFolder, kiekerFolder.getName() + ".tar");
        ProcessBuilder processBuilder = new ProcessBuilder("tar", "-czf", dest.getAbsolutePath(), kiekerFolder.getAbsolutePath());
        processBuilder.environment().put("GZIP", "-9");
        Process process = processBuilder.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public int getThresholdForDeletingInMB() {
        return this.thresholdForDeletingInMB;
    }

    public void setThresholdForDeletingInMB(int thresholdForDeletingInMB) {
        this.thresholdForDeletingInMB = thresholdForDeletingInMB;
    }

    public int getThresholdForZippingInMB() {
        return this.thresholdForZippingInMB;
    }

    public void setThresholdForZippingInMB(int thresholdForZippingInMB) {
        this.thresholdForZippingInMB = thresholdForZippingInMB;
    }
}

