/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.organize;

import de.dagere.kopeme.datastorage.JSONDataLoader;
import de.dagere.kopeme.datastorage.JSONDataStorer;
import de.dagere.kopeme.datastorage.ParamNameHelper;
import de.dagere.kopeme.kopemedata.DatacollectorResult;
import de.dagere.kopeme.kopemedata.Fulldata;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.kopeme.kopemedata.TestMethod;
import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.dataloading.MultipleVMTestUtil;
import de.dagere.peass.measurement.organize.KiekerFileCompressor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultOrganizer {
    private static final Logger LOG = LogManager.getLogger(ResultOrganizer.class);
    protected final PeassFolders folders;
    private final String mainCommit;
    private final long currentChunkStart;
    private final boolean isUseKieker;
    private final boolean saveAll;
    protected final TestMethodCall testcase;
    private boolean success = true;
    private final int expectedIterations;
    private final KiekerFileCompressor compressor = new KiekerFileCompressor();

    public ResultOrganizer(PeassFolders folders, String currentCommit, long currentChunkStart, boolean isUseKieker, boolean saveAll, TestMethodCall test, int expectedIterations) {
        this.folders = folders;
        this.mainCommit = currentCommit;
        this.currentChunkStart = currentChunkStart;
        this.isUseKieker = isUseKieker;
        this.saveAll = saveAll;
        this.testcase = test;
        this.expectedIterations = expectedIterations;
    }

    public boolean testSuccess(String commit) {
        File folder = this.getTempResultsFolder(commit);
        if (folder != null) {
            String methodname = this.testcase.getMethodWithParams();
            File oneResultFile = new File(folder, methodname + ".json");
            if (!oneResultFile.exists()) {
                this.success = false;
                LOG.error("Result file {} does not exist - probably timeout", (Object)oneResultFile);
            } else {
                LOG.debug("Reading: {}", (Object)oneResultFile);
                Kopemedata oneResultData = JSONDataLoader.loadData((File)oneResultFile);
                List testcaseList = oneResultData.getMethods();
                if (testcaseList.size() > 0) {
                    VMResult result = oneResultData.getFirstResult();
                    if (result.getIterations() == (long)this.expectedIterations) {
                        this.success = true;
                    } else {
                        this.success = false;
                        LOG.error("Wrong execution count: {} Expected: {}", (Object)result.getIterations(), (Object)this.expectedIterations);
                    }
                } else {
                    LOG.error("Testcase not found in XML");
                    this.success = false;
                }
            }
        } else {
            LOG.error("Folder {} does not exist", (Object)folder);
            this.success = false;
        }
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveResultFiles(String commit, int vmid) {
        Class<ResultOrganizer> clazz = ResultOrganizer.class;
        synchronized (ResultOrganizer.class) {
            try {
                File folder = this.getTempResultsFolder(commit);
                if (folder != null) {
                    String methodname = this.testcase.getMethodWithParams();
                    File oneResultFile = new File(folder, methodname + ".json");
                    if (!oneResultFile.exists()) {
                        oneResultFile = new File(folder, this.testcase.getMethod() + ".json");
                    }
                    if (!oneResultFile.exists()) {
                        LOG.debug("File {} does not exist.", (Object)oneResultFile.getAbsolutePath());
                        this.success = false;
                    } else {
                        LOG.debug("Reading: {}", (Object)oneResultFile);
                        Kopemedata oneResultData = JSONDataLoader.loadData((File)oneResultFile);
                        List testcaseList = oneResultData.getMethods();
                        if (testcaseList.size() > 0) {
                            this.saveResults(commit, vmid, oneResultFile, oneResultData, testcaseList);
                            if (this.isUseKieker) {
                                File destFolder = this.folders.getFullResultFolder((TestCase)this.testcase, this.mainCommit, commit);
                                this.saveKiekerFiles(folder, destFolder);
                            }
                        } else {
                            LOG.error("No data - measurement failed?");
                            this.success = false;
                        }
                    }
                    for (File file : folder.listFiles()) {
                        FileUtils.forceDelete((File)file);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    public File getTempResultsFolder(String commit) {
        LOG.info("Searching method: {}", (Object)this.testcase);
        List folderCandidates = this.folders.findTempClazzFolder((TestCase)this.testcase);
        if (folderCandidates.size() != 1) {
            LOG.error("Ordner {} ist {} mal vorhanden.", (Object)this.testcase.getClazz(), (Object)folderCandidates.size());
            return null;
        }
        File folder = (File)folderCandidates.iterator().next();
        return folder;
    }

    private void saveResults(String commit, int vmid, File oneResultFile, Kopemedata oneResultData, List<TestMethod> testcaseList) throws IOException {
        DatacollectorResult timeDataCollector = oneResultData.getFirstTimeDataCollector();
        this.saveSummaryFile(commit, timeDataCollector, oneResultFile);
        for (VMResult result : timeDataCollector.getResults()) {
            String paramString = ParamNameHelper.paramsToString((LinkedHashMap)result.getParameters());
            TestMethodCall concreteTestcase = new TestMethodCall(this.testcase.getClazz(), this.testcase.getMethod(), this.testcase.getModule(), paramString);
            File destFile = this.folders.getResultFile(concreteTestcase, vmid, commit, this.mainCommit);
            destFile.getParentFile().mkdirs();
            LOG.info("Saving in: {}", (Object)destFile);
            if (!destFile.exists()) {
                Fulldata fulldata = result.getFulldata();
                if (fulldata.getFileName() != null) {
                    this.saveFulldataFile(vmid, oneResultFile, destFile, fulldata);
                }
                Kopemedata copiedData = JSONDataStorer.clone((Kopemedata)oneResultData);
                DatacollectorResult copiedTimeDataCollector = copiedData.getFirstTimeDataCollector();
                copiedTimeDataCollector.getResults().clear();
                copiedTimeDataCollector.getResults().add(result);
                JSONDataStorer.storeData((File)destFile, (Kopemedata)copiedData);
                oneResultFile.delete();
                continue;
            }
            throw new RuntimeException("Moving failed: " + String.valueOf(destFile) + " already exist.");
        }
    }

    private void saveFulldataFile(int vmid, File oneResultFile, File destFile, Fulldata fulldata) throws IOException {
        File fulldataFile = new File(oneResultFile.getParentFile(), fulldata.getFileName());
        String destFileName = this.testcase.getMethod() + "_kopeme_" + vmid + ".tmp";
        File destKopemeFile = new File(destFile.getParentFile(), destFileName);
        Files.move(fulldataFile.toPath(), destKopemeFile.toPath(), new CopyOption[0]);
        fulldata.setFileName(destFileName);
    }

    public void saveSummaryFile(String commit, DatacollectorResult timeDataCollector, File oneResultFile) {
        for (VMResult result : timeDataCollector.getResults()) {
            String paramString = ParamNameHelper.paramsToString((LinkedHashMap)result.getParameters());
            TestMethodCall concreteTestcase = new TestMethodCall(this.testcase.getClazz(), this.testcase.getMethod(), this.testcase.getModule(), paramString);
            File summaryResultFile = this.folders.getSummaryFile(concreteTestcase);
            MultipleVMTestUtil.saveSummaryData(summaryResultFile, oneResultFile, result, concreteTestcase, commit, this.currentChunkStart, timeDataCollector.getName());
        }
    }

    private void saveKiekerFiles(File folder, File destFolder) throws IOException {
        Object[] kiekerFolders = folder.listFiles((FilenameFilter)new RegexFileFilter("[0-9]*"));
        if (kiekerFolders.length != 1) {
            String fileNameList = Arrays.toString(kiekerFolders);
            throw new RuntimeException("It is expected that after one execution exactly one Kieker folder exists, but was " + fileNameList);
        }
        if (this.saveAll) {
            this.compressor.moveOrCompressFile(destFolder, (File)kiekerFolders[0]);
        } else {
            FileUtils.deleteDirectory((File)kiekerFolders[0]);
        }
    }

    public KiekerFileCompressor getCompressor() {
        return this.compressor;
    }

    public File getResultFile(TestMethodCall testcase, int vmid, String commit) {
        return this.folders.getResultFile(testcase, vmid, commit, this.mainCommit);
    }

    public PeassFolders getFolders() {
        return this.folders;
    }

    public boolean isSaveAll() {
        return this.saveAll;
    }

    public TestMethodCall getTest() {
        return this.testcase;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

