/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.organize;

import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.organize.ResultOrganizer;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultOrganizerParallel
extends ResultOrganizer {
    private static final Logger LOG = LogManager.getLogger(ResultOrganizerParallel.class);
    private final Map<String, PeassFolders> sourceFolders = new HashMap<String, PeassFolders>();

    public ResultOrganizerParallel(PeassFolders folders, String currentVersion, long currentChunkStart, boolean isUseKieker, boolean saveAll, TestMethodCall test, int expectedIterations) {
        super(folders, currentVersion, currentChunkStart, isUseKieker, saveAll, test, expectedIterations);
        LOG.trace("Creating new ResultOrganizerParallel");
        LOG.trace("Instance: {}", (Object)System.identityHashCode(this));
    }

    public void addCommitFolders(String commit, PeassFolders commitTempFolder) {
        LOG.debug("Adding commit: {}", (Object)commit);
        this.sourceFolders.put(commit, commitTempFolder);
        LOG.trace("Instance: {} Keys: {}", (Object)System.identityHashCode(this), this.sourceFolders.keySet());
    }

    @Override
    public File getTempResultsFolder(String commit) {
        PeassFolders currentFolders = this.sourceFolders.get(commit);
        LOG.info("Searching method: {} Version: {} Existing commits: {}", (Object)this.testcase, (Object)commit, this.sourceFolders.keySet());
        LOG.info("Instance: " + System.identityHashCode(this));
        List folderCandidates = currentFolders.findTempClazzFolder((TestCase)this.testcase);
        if (folderCandidates.size() != 1) {
            LOG.error("Folder with name {} is existing {} times.", (Object)this.testcase.getClazz(), (Object)folderCandidates.size());
            return null;
        }
        File folder = (File)folderCandidates.iterator().next();
        return folder;
    }
}

