/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca;

import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.folders.CauseSearchFolders;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.data.CauseSearchData;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;

public class CausePersistenceManager {
    protected final CauseSearchData data;
    protected final CauseSearchData dataDetails;
    private final CauseSearchFolders folders;
    private final File treeDataFile;
    private final File treeDataFileDetails;

    public CausePersistenceManager(CauseSearcherConfig causeSearchConfig, MeasurementConfig measurementConfig, CauseSearchFolders folders) {
        this(new CauseSearchData(measurementConfig, causeSearchConfig), new CauseSearchData(measurementConfig, causeSearchConfig), folders);
    }

    public CausePersistenceManager(CauseSearchData finishedData, CauseSearchData finishedDataFull, CauseSearchFolders folders) {
        this.data = finishedData;
        this.dataDetails = finishedDataFull;
        this.folders = folders;
        String commit = finishedData.getMeasurementConfig().getFixedCommitConfig().getCommit();
        TestMethodCall testCase = finishedData.getCauseConfig().getTestCase();
        File treeDataFolder = folders.getRcaTreeFolder(commit, (TestCase)testCase);
        this.treeDataFile = folders.getRcaTreeFile(commit, testCase);
        if (this.treeDataFile.exists()) {
            throw new RuntimeException("Old tree data folder " + this.treeDataFile.getAbsolutePath() + " exists - please cleanup!");
        }
        treeDataFolder.mkdirs();
        this.treeDataFileDetails = folders.getRcaTreeFileDetails(commit, testCase);
        this.treeDataFileDetails.getParentFile().mkdirs();
    }

    public void writeTreeState() {
        try {
            Constants.OBJECTMAPPER.writeValue(this.treeDataFile, (Object)this.data);
            Constants.OBJECTMAPPER.writeValue(this.treeDataFileDetails, (Object)this.dataDetails);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addMeasurement(CallTreeNode predecessorNode) {
        this.data.addDiff(predecessorNode);
        this.dataDetails.addDetailDiff(predecessorNode);
    }

    public CauseSearchData getRCAData() {
        return this.data;
    }

    public CauseSearchFolders getFolders() {
        return this.folders;
    }
}

