/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.measurement.rca.CauseSearcherConfigMixin;
import de.dagere.peass.measurement.rca.RCAStrategy;
import java.io.File;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CauseSearcherConfig
implements Serializable {
    private static final long serialVersionUID = 5893295648840988829L;
    private final TestMethodCall testCase;
    private final boolean ignoreEOIs;
    private final boolean splitAggregated;
    private final double minTime;
    private final boolean calibrationRun;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private File propertyFolder;
    private final RCAStrategy rcaStrategy;
    private final int levels;

    @JsonCreator
    public CauseSearcherConfig(@JsonProperty(value="testcase") TestMethodCall testCase, @JsonProperty(value="splitAggregated") boolean splitAggregated, @JsonProperty(value="minTime") double minTime, @JsonProperty(value="calibrationRun") boolean calibrationRun, @JsonProperty(value="ignoreEOIs") boolean ignoreEOIs, @JsonProperty(value="rcaStrategy") RCAStrategy rcaStrategy, @JsonProperty(value="levels") int levels) {
        this.testCase = testCase;
        this.splitAggregated = splitAggregated;
        this.minTime = minTime;
        this.calibrationRun = calibrationRun;
        this.ignoreEOIs = ignoreEOIs;
        this.rcaStrategy = rcaStrategy;
        this.levels = levels;
        this.propertyFolder = null;
        if (rcaStrategy != RCAStrategy.LEVELWISE && levels > 1) {
            throw new RuntimeException("If levels > 1, strategy must be LEVELWISE");
        }
        if (rcaStrategy == RCAStrategy.LEVELWISE && levels < 1) {
            throw new RuntimeException("Levels need to be 1 or above!");
        }
    }

    public CauseSearcherConfig(TestMethodCall test, CauseSearcherConfigMixin config) {
        this(test, !config.isNotSplitAggregated(), config.getMinTime(), config.isUseCalibrationRun(), !config.isUseEOIs(), config.getStrategy(), config.getLevels());
        this.propertyFolder = config.getPropertyFolder();
    }

    public CauseSearcherConfig(TestMethodCall testCase, CauseSearcherConfig causeConfig) {
        this(testCase, causeConfig.isSplitAggregated(), causeConfig.getMinTime(), causeConfig.useCalibrationRun(), causeConfig.isIgnoreEOIs(), causeConfig.getRcaStrategy(), causeConfig.getLevels());
        this.propertyFolder = causeConfig.getPropertyFolder();
    }

    public TestMethodCall getTestCase() {
        return this.testCase;
    }

    public boolean isSplitAggregated() {
        return this.splitAggregated;
    }

    public double getMinTime() {
        return this.minTime;
    }

    public boolean useCalibrationRun() {
        return this.calibrationRun;
    }

    public boolean isIgnoreEOIs() {
        return this.ignoreEOIs;
    }

    public RCAStrategy getRcaStrategy() {
        return this.rcaStrategy;
    }

    public void setPropertyFolder(File propertyFolder) {
        this.propertyFolder = propertyFolder;
    }

    public File getPropertyFolder() {
        return this.propertyFolder;
    }

    public int getLevels() {
        return this.levels;
    }
}

