/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca;

import de.dagere.peass.measurement.rca.RCAStrategy;
import java.io.File;
import picocli.CommandLine;

public class CauseSearcherConfigMixin {
    @CommandLine.Option(names={"-useCalibrationRun", "--useCalibrationRun"}, description={"Use the calibration run for complete measurements"})
    private boolean useCalibrationRun = false;
    @CommandLine.Option(names={"-useEOIs", "--useEOIs"}, description={"Use EOIs - nodes will be considered different if their kieker pattern or ess differ (needs space and computation time for big trees)"})
    private boolean useEOIs = false;
    @CommandLine.Option(names={"-notSplitAggregated", "--notSplitAggregated"}, description={"Whether to split the aggregated data (produces aggregated data per time slice)"})
    private boolean notSplitAggregated = false;
    @CommandLine.Option(names={"-propertyFolder", "--propertyFolder"}, description={"Path to property folder"}, required=false)
    protected File propertyFolder;
    @CommandLine.Option(names={"-minTime", "--minTime"}, description={"Minimum node difference time compared to relative standard deviation. If a node takes less time, its childs won't be measured (since time measurement isn't below accurate below a certain value)."})
    private double minTime = 0.1;
    @CommandLine.Option(names={"-rcaStrategy", "--rcaStrategy"}, description={"Strategy to select nodes which are measured (default: COMPLETE)"})
    private RCAStrategy strategy = RCAStrategy.COMPLETE;
    @CommandLine.Option(names={"-levels", "--levels"}, description={"Count of levels that should be measured at once; only allowed with strategy CONSTANT_LEVELS"})
    private int levels = 1;

    public boolean isUseCalibrationRun() {
        return this.useCalibrationRun;
    }

    public boolean isUseEOIs() {
        return this.useEOIs;
    }

    public boolean isNotSplitAggregated() {
        return this.notSplitAggregated;
    }

    public double getMinTime() {
        return this.minTime;
    }

    public RCAStrategy getStrategy() {
        return this.strategy;
    }

    public File getPropertyFolder() {
        return this.propertyFolder;
    }

    public int getLevels() {
        return this.levels;
    }
}

