/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca;

import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.CauseSearchFolders;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.dependencyprocessors.AdaptiveTester;
import de.dagere.peass.measurement.dependencyprocessors.helper.EarlyBreakDecider;
import de.dagere.peass.measurement.dependencyprocessors.helper.ProgressWriter;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.PatternSetGenerator;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.kieker.KiekerResultReader;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CauseTester
extends AdaptiveTester {
    private static final Logger LOG = LogManager.getLogger(CauseTester.class);
    private Set<CallTreeNode> includedNodes;
    private Set<String> includedPattern;
    private final TestMethodCall testcase;
    private final CauseSearcherConfig causeConfig;
    private final CauseSearchFolders folders;
    private int levelId = 0;

    public CauseTester(CauseSearchFolders project, MeasurementConfig measurementConfig, CauseSearcherConfig causeConfig, EnvironmentVariables env, CommitComparatorInstance comparator) {
        super((PeassFolders)project, measurementConfig, env, comparator);
        this.testcase = causeConfig.getTestCase();
        this.causeConfig = causeConfig;
        this.folders = project;
    }

    public void measureCommit(List<CallTreeNode> nodes) {
        this.includedNodes = this.prepareNodes(nodes);
        this.evaluate(this.causeConfig.getTestCase());
        if (!this.getCurrentOrganizer().isSuccess()) {
            boolean shouldBreak = this.reductionManager.reduceExecutions(false, this.configuration.getIterations() / 2);
            this.configuration.setIterations(this.configuration.getIterations() / 2);
            if (shouldBreak) {
                throw new RuntimeException("Execution took too long, Iterations: " + this.configuration.getIterations() + " Warmup: " + this.configuration.getWarmup() + " Repetitions: " + this.configuration.getRepetitions());
            }
        } else {
            this.getDurations(this.levelId);
        }
        this.cleanup(this.levelId);
        ++this.levelId;
    }

    private Set<CallTreeNode> prepareNodes(List<CallTreeNode> nodes) {
        HashSet<CallTreeNode> includedNodes = new HashSet<CallTreeNode>();
        nodes.forEach(node -> {
            if (!node.getConfig().getKiekerConfig().isMeasureAdded()) {
                if (!node.getKiekerPattern().equals("ADDED") && !node.getOtherKiekerPattern().equals("ADDED")) {
                    includedNodes.add((CallTreeNode)node);
                }
            } else {
                includedNodes.add((CallTreeNode)node);
            }
        });
        nodes.forEach(node -> node.initCommitData());
        return includedNodes;
    }

    @Override
    public void evaluate(TestMethodCall testcase) {
        LOG.debug("Adaptive execution: " + String.valueOf(this.includedNodes));
        this.initEvaluation(testcase);
        File logFolder = this.folders.getRCALogFolder(this.configuration.getFixedCommitConfig().getCommit(), testcase, this.levelId);
        try (ProgressWriter writer = new ProgressWriter(this.folders.getProgressFile(), this.configuration.getVms());){
            this.evaluateWithAdaption(testcase, logFolder, writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected synchronized TestExecutor getExecutor(PeassFolders temporaryFolders, String commit) {
        TestExecutor testExecutor = super.getExecutor(temporaryFolders, commit);
        TestTransformer testTransformer = testExecutor.getTestTransformer();
        testTransformer.setIgnoreEOIs(this.causeConfig.isIgnoreEOIs());
        PatternSetGenerator patternSetGenerator = new PatternSetGenerator(this.configuration.getFixedCommitConfig(), this.testcase);
        this.includedPattern = patternSetGenerator.generatePatternSet(this.includedNodes, commit);
        HashSet<String> includedMethodPattern = new HashSet<String>(this.includedPattern);
        testExecutor.setIncludedMethods(includedMethodPattern);
        return testExecutor;
    }

    @Override
    public boolean checkIsDecidable(TestMethodCall testcase, int vmid) {
        this.getDurationsCommit(this.configuration.getFixedCommitConfig().getCommit());
        this.getDurationsCommit(this.configuration.getFixedCommitConfig().getCommitOld());
        boolean allDecidable = super.checkIsDecidable(testcase, vmid);
        LOG.debug("Super decidable: {}", (Object)allDecidable);
        for (CallTreeNode includedNode : this.includedNodes) {
            allDecidable &= this.checkLevelDecidable(vmid, allDecidable, includedNode);
        }
        LOG.debug("Level decideable: {}", (Object)allDecidable);
        return allDecidable;
    }

    private boolean checkLevelDecidable(int vmid, boolean allDecidable, CallTreeNode includedNode) {
        SummaryStatistics statisticsOld = includedNode.getStatistics(this.configuration.getFixedCommitConfig().getCommitOld());
        SummaryStatistics statistics = includedNode.getStatistics(this.configuration.getFixedCommitConfig().getCommit());
        EarlyBreakDecider decider = new EarlyBreakDecider(this.configuration, (StatisticalSummary)statisticsOld, (StatisticalSummary)statistics);
        boolean nodeDecidable = decider.isBreakPossible(vmid);
        LOG.debug("{} decideable: {}", (Object)includedNode.getKiekerPattern(), (Object)allDecidable);
        LOG.debug("Old: {} {} Current: {} {}", (Object)statisticsOld.getMean(), (Object)statisticsOld.getStandardDeviation(), (Object)statistics.getMean(), (Object)statistics.getStandardDeviation());
        return nodeDecidable;
    }

    @Override
    public void handleKiekerResults(String commit, File commitResultFolder) {
        if (this.getCurrentOrganizer().testSuccess(commit)) {
            LOG.info("Did succeed in measurement - analyse values");
            boolean isOtherVersion = commit.equals(this.configuration.getFixedCommitConfig().getCommit());
            KiekerResultReader kiekerResultReader = new KiekerResultReader(this.configuration.getKiekerConfig().isUseAggregation(), this.configuration.getKiekerConfig().getRecord(), this.causeConfig.getRcaStrategy(), this.includedNodes, commit, this.testcase, isOtherVersion);
            kiekerResultReader.setConsiderNodePosition(!this.configuration.getKiekerConfig().isUseAggregation());
            kiekerResultReader.readResults(commitResultFolder);
        } else {
            LOG.info("Did not success in measurement");
        }
    }

    public void setIncludedMethods(Set<CallTreeNode> children) {
        this.includedNodes = children;
    }

    public void getDurations(int levelId) {
        this.getDurationsCommit(this.configuration.getFixedCommitConfig().getCommit());
        this.getDurationsCommit(this.configuration.getFixedCommitConfig().getCommitOld());
    }

    public void cleanup(int levelId) {
        this.organizeMeasurements(levelId, this.configuration.getFixedCommitConfig().getCommit(), this.configuration.getFixedCommitConfig().getCommit());
        this.organizeMeasurements(levelId, this.configuration.getFixedCommitConfig().getCommit(), this.configuration.getFixedCommitConfig().getCommitOld());
    }

    private void organizeMeasurements(int levelId, String mainCommit, String commit) {
        File testcaseFolder = this.folders.getFullResultFolder((TestCase)this.testcase, mainCommit, commit);
        File commitFolder = new File(this.folders.getArchiveResultFolder(mainCommit, this.testcase), commit);
        if (!commitFolder.exists()) {
            commitFolder.mkdir();
        }
        File adaptiveRunFolder = new File(commitFolder, "" + levelId);
        try {
            FileUtils.moveDirectory((File)testcaseFolder, (File)adaptiveRunFolder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void getDurationsCommit(String commit) {
        this.includedNodes.forEach(node -> node.createStatistics(commit));
    }

    public void setCurrentCommit(String commit) {
        this.configuration.getFixedCommitConfig().setCommit(commit);
        this.configuration.getFixedCommitConfig().setCommitOld(commit + "~1");
    }
}

