/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependencyprocessors.CommitByNameComparator;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.CauseSearchFolders;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.CauseTester;
import de.dagere.peass.measurement.rca.RCAStrategy;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.kieker.BothTreeReader;
import de.dagere.peass.measurement.rca.searcher.LevelCauseSearcher;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kieker.analysis.exception.AnalysisConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class LevelCauseSearchExperimentalStarter {
    private static final Logger LOG = LogManager.getLogger(LevelCauseSearchExperimentalStarter.class);

    public static void main(String[] args) throws IOException, XmlPullParserException, InterruptedException, IllegalStateException, AnalysisConfigurationException {
        File projectFolder = new File("../../projekte/commons-fileupload");
        String commit = "4ed6e923cb2033272fcb993978d69e325990a5aa";
        TestMethodCall test = new TestMethodCall("org.apache.commons.fileupload.ServletFileUploadTest", "testFoldedHeaders");
        MeasurementConfig measurementConfiguration = new MeasurementConfig(900000L, 5, true, "4ed6e923cb2033272fcb993978d69e325990a5aa", "4ed6e923cb2033272fcb993978d69e325990a5aa~1");
        measurementConfiguration.getKiekerConfig().setUseKieker(true);
        CauseSearcherConfig causeSearcherConfig = new CauseSearcherConfig(test, false, 0.1, false, false, RCAStrategy.COMPLETE, 1);
        CauseSearchFolders folders2 = new CauseSearchFolders(projectFolder);
        BothTreeReader reader = new BothTreeReader(causeSearcherConfig, measurementConfiguration, folders2, new EnvironmentVariables());
        CauseTester measurer = new CauseTester(folders2, measurementConfiguration, causeSearcherConfig, new EnvironmentVariables(), (CommitComparatorInstance)CommitByNameComparator.INSTANCE);
        LevelCauseSearcher searcher = new LevelCauseSearcher(reader, causeSearcherConfig, measurer, measurementConfiguration, folders2, new EnvironmentVariables());
        reader.readTrees();
        List<CallTreeNode> predecessor = Arrays.asList(reader.getRootPredecessor());
        List<CallTreeNode> current = Arrays.asList(reader.getRootCurrent());
        int level = 0;
        boolean hasChilds = true;
        while (hasChilds) {
            LOG.info("Level: " + ++level + " " + predecessor.get(0).getKiekerPattern());
            boolean foundNodeLevel = false;
            LinkedList<CallTreeNode> predecessorNew = new LinkedList<CallTreeNode>();
            LinkedList<CallTreeNode> currentNew = new LinkedList<CallTreeNode>();
            Iterator<CallTreeNode> currentIterator = current.iterator();
            Iterator<CallTreeNode> preIterator = predecessor.iterator();
            while (preIterator.hasNext() && currentIterator.hasNext()) {
                CallTreeNode predecessorChild = preIterator.next();
                CallTreeNode currentChild = currentIterator.next();
                predecessorNew.addAll(predecessorChild.getChildren());
                currentNew.addAll(currentChild.getChildren());
                String searchedCall = "public static long org.apache.commons.fileupload.util.Streams.copy(java.io.InputStream,java.io.OutputStream,boolean,byte[])";
                if (predecessorChild.getKiekerPattern().equals("public static long org.apache.commons.fileupload.util.Streams.copy(java.io.InputStream,java.io.OutputStream,boolean,byte[])") && currentChild.getKiekerPattern().equals("public static long org.apache.commons.fileupload.util.Streams.copy(java.io.InputStream,java.io.OutputStream,boolean,byte[])")) {
                    foundNodeLevel = true;
                }
                if (predecessorChild.getKiekerPattern().equals("public static long org.apache.commons.fileupload.util.Streams.copy(java.io.InputStream,java.io.OutputStream,boolean,byte[])") == currentChild.getKiekerPattern().equals("public static long org.apache.commons.fileupload.util.Streams.copy(java.io.InputStream,java.io.OutputStream,boolean,byte[])")) continue;
                LOG.info(predecessorChild.getKiekerPattern());
                LOG.info(currentChild.getKiekerPattern());
                throw new RuntimeException("Tree structure differs above searched node!");
            }
            if (foundNodeLevel) {
                LOG.info("Found!");
                searcher.isLevelDifferent(predecessorNew, currentNew);
            }
            predecessor = predecessorNew;
            current = currentNew;
            if (!predecessor.isEmpty()) continue;
            hasChilds = false;
        }
    }
}

