/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca;

import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.kieker.BothTreeReader;
import de.dagere.peass.measurement.rca.serialization.MeasuredNode;
import de.dagere.peass.measurement.rca.treeanalysis.TreeUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LevelManager {
    private static final Logger LOG = LogManager.getLogger(LevelManager.class);
    private final List<CallTreeNode> mainVersionNodeList;
    private final List<CallTreeNode> predecessorNodeList;

    public LevelManager(List<CallTreeNode> mainVersionNodeList, List<CallTreeNode> currentPredecessorNodeList, BothTreeReader reader) {
        this.mainVersionNodeList = mainVersionNodeList;
        this.predecessorNodeList = currentPredecessorNodeList;
        mainVersionNodeList.add(reader.getRootCurrent());
        currentPredecessorNodeList.add(reader.getRootPredecessor());
        reader.getRootCurrent().setOtherCommitNode(reader.getRootPredecessor());
        reader.getRootPredecessor().setOtherCommitNode(reader.getRootCurrent());
    }

    public void goToLastMeasuredLevel(MeasuredNode root) {
        LinkedList<MeasuredNode> persistentNodes = new LinkedList<MeasuredNode>();
        persistentNodes.add(root);
        HashSet<CallTreeNode> predecessorNextLevel = new HashSet<CallTreeNode>();
        HashSet<CallTreeNode> mainNextLevel = new HashSet<CallTreeNode>();
        do {
            predecessorNextLevel.clear();
            mainNextLevel.clear();
            LOG.debug("Node: {} {} {}", persistentNodes, this.predecessorNodeList, this.mainVersionNodeList);
            LinkedList<MeasuredNode> persistentNextLevel = new LinkedList<MeasuredNode>();
            boolean anyHasChild = false;
            for (MeasuredNode measuredNode : persistentNodes) {
                if (measuredNode.getChilds().isEmpty()) continue;
                this.searchCallTreeNodes(predecessorNextLevel, mainNextLevel, persistentNextLevel, measuredNode);
                anyHasChild = true;
            }
            if (!anyHasChild) continue;
            persistentNodes.clear();
            persistentNodes.addAll(persistentNextLevel);
            this.predecessorNodeList.clear();
            this.predecessorNodeList.addAll(predecessorNextLevel);
            this.mainVersionNodeList.clear();
            this.mainVersionNodeList.addAll(mainNextLevel);
        } while (!predecessorNextLevel.isEmpty() && !mainNextLevel.isEmpty());
        this.setLastLevel(this.mainVersionNodeList, mainNextLevel);
        this.setLastLevel(this.predecessorNodeList, predecessorNextLevel);
        LOG.debug("Nodes: {} {}", (Object)this.predecessorNodeList.size(), (Object)this.mainVersionNodeList.size());
    }

    private void setLastLevel(List<CallTreeNode> nodeList, Set<CallTreeNode> nextLevel) {
        for (CallTreeNode processedNode : nodeList) {
            System.out.println("Searching mapping: " + String.valueOf(processedNode) + " " + String.valueOf(processedNode.getOtherCommitNode()));
            TreeUtil.findChildMapping(processedNode, processedNode.getOtherCommitNode());
            nextLevel.addAll(processedNode.getChildren());
        }
        nodeList.clear();
        nodeList.addAll(nextLevel);
        nextLevel.clear();
    }

    private void searchCallTreeNodes(Set<CallTreeNode> predecessorNextLevel, Set<CallTreeNode> mainNextLevel, List<MeasuredNode> persistentNextLevel, MeasuredNode measuredNode) {
        for (MeasuredNode persistentChild : measuredNode.getChilds()) {
            CallTreeNode reusePredecessor = this.getSameParent(this.predecessorNodeList, persistentChild);
            CallTreeNode reuseMain = this.getSameParent(this.mainVersionNodeList, persistentChild);
            if (reuseMain == null || reusePredecessor == null) continue;
            reusePredecessor.setOtherCommitNode(reuseMain);
            reuseMain.setOtherCommitNode(reusePredecessor);
            mainNextLevel.add(reuseMain);
            predecessorNextLevel.add(reusePredecessor);
            persistentNextLevel.add(persistentChild);
        }
    }

    private CallTreeNode getSameParent(List<CallTreeNode> currentVersionNodeList, MeasuredNode persistentChild) {
        CallTreeNode reuse = null;
        block0: for (CallTreeNode parentNode : currentVersionNodeList) {
            for (CallTreeNode child : parentNode.getChildren()) {
                if (!child.getKiekerPattern().equals(persistentChild.getKiekerPattern())) continue;
                reuse = child;
                continue block0;
            }
        }
        return reuse;
    }
}

