/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.FixedCommitConfig;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PatternSetGenerator {
    private static final Logger LOG = LogManager.getLogger(PatternSetGenerator.class);
    private final FixedCommitConfig config;
    private final TestMethodCall testcase;

    public PatternSetGenerator(FixedCommitConfig config, TestMethodCall testcase) {
        this.config = config;
        this.testcase = testcase;
    }

    public Set<String> generatePatternSet(Set<CallTreeNode> includedNodes, String commit) {
        HashSet<String> includedPattern = new HashSet<String>();
        if (this.config.getCommitOld().equals(commit)) {
            includedNodes.forEach(node -> {
                LOG.trace(node);
                if (!node.getKiekerPattern().equals("ADDED")) {
                    this.addIncludedPattern((CallTreeNode)node, node.getKiekerPattern(), (Set<String>)includedPattern);
                }
            });
        } else {
            LOG.debug("Searching other: " + commit);
            includedNodes.forEach(node -> {
                LOG.trace(node);
                if (!node.getOtherKiekerPattern().equals("ADDED")) {
                    this.addIncludedPattern((CallTreeNode)node, node.getOtherKiekerPattern(), (Set<String>)includedPattern);
                }
            });
        }
        return includedPattern;
    }

    private void addIncludedPattern(CallTreeNode node, String addPattern, Set<String> includedPattern) {
        if (node.getCall().equals(this.testcase.getExecutable()) && addPattern.startsWith("public ")) {
            includedPattern.add(addPattern.substring("public ".length()));
            includedPattern.add(addPattern);
        } else {
            includedPattern.add(addPattern);
        }
    }
}

