/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca;

import de.dagere.peass.measurement.rca.CausePersistenceManager;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RCAMeasurementAdder {
    private static final Logger LOG = LogManager.getLogger(RCAMeasurementAdder.class);
    private final CausePersistenceManager persistenceManager;
    private final List<CallTreeNode> includableNodes;

    public RCAMeasurementAdder(CausePersistenceManager persistenceManager, List<CallTreeNode> includableNodes) {
        this.persistenceManager = persistenceManager;
        this.includableNodes = includableNodes;
    }

    public void addAllMeasurements(CallTreeNode root) {
        this.persistenceManager.addMeasurement(root);
        this.addMeasurements(root);
    }

    private void addMeasurements(CallTreeNode parent) {
        for (CallTreeNode child : parent.getChildren()) {
            if (!this.includableNodes.contains(child)) continue;
            LOG.debug("Analyzing: {}", (Object)child);
            this.persistenceManager.addMeasurement(child);
            this.addMeasurements(child);
        }
    }
}

